/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.project.ProjectTreeNode;
import csbase.client.project.SelectionModeStateInterface;
import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileFilter;
import csbase.util.collections.NoDuplicatesCollection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public final class ProjectTreeSelectionModel
implements TreeSelectionModel {
    private ProjectFileFilter filter;
    private Set<TreeSelectionListener> treeSelectionListenerSet;
    private NoDuplicatesCollection<TreePath> selectedPaths;
    private int[] selectedRows;
    private RowMapper rowMapper;
    private SelectionModeStateInterface selectionModeState;
    private final SelectionModeStateSingle SINGLE_TREE_SELECTION_STATE = new SelectionModeStateSingle();
    private final SelectionModeStateDiscontiguous DISCONTIGUOUS_TREE_SELECTION_STATE = new SelectionModeStateDiscontiguous();
    private int selectionMode;
    private Set<PropertyChangeListener> propertyChangeListenerSet;
    private static final String SELECTION_MODE_PROPERTY = "selectionMode";

    public ProjectTreeSelectionModel() {
        this(null);
    }

    public ProjectTreeSelectionModel(ProjectFileFilter filter) {
        this.treeSelectionListenerSet = new HashSet<TreeSelectionListener>();
        this.propertyChangeListenerSet = new HashSet<PropertyChangeListener>();
        this.selectedPaths = new NoDuplicatesCollection();
        this.setSelectionMode(4);
        this.setFilter(filter);
    }

    ProjectFileFilter getFilter() {
        return this.filter;
    }

    void setFilter(ProjectFileFilter filter) {
        this.filter = filter;
        this.updateSelection();
    }

    private void updateSelection() {
        NoDuplicatesCollection<TreePath> newSelection = this.filterPaths(ProjectTreeSelectionModel.getTreePathArrayFromList(this.selectedPaths));
        if (newSelection.isEmpty()) {
            this.selectionModeState.removeSelectionPaths((NoDuplicatesCollection<TreePath>)this.selectedPaths.clone());
        } else {
            this.selectionModeState.setSelectionPaths(newSelection);
        }
        this.resetRowSelection();
    }

    private int getLeadSelectionIndex() {
        return this.selectedPaths.size() - 1;
    }

    @Override
    public int getLeadSelectionRow() {
        if (this.rowMapper == null) {
            return -1;
        }
        return this.selectedRows[this.getLeadSelectionIndex()];
    }

    @Override
    public int getMaxSelectionRow() {
        if (this.rowMapper == null) {
            return -1;
        }
        if (this.selectedRows.length == 0) {
            return -1;
        }
        int max = this.selectedRows[0];
        int i = 1;
        while (i < this.selectedRows.length) {
            max = Math.max(max, this.selectedRows[i]);
            ++i;
        }
        return max;
    }

    @Override
    public int getMinSelectionRow() {
        if (this.rowMapper == null) {
            return -1;
        }
        if (this.selectedRows.length == 0) {
            return -1;
        }
        int min = this.selectedRows[0];
        int i = 1;
        while (i < this.selectedRows.length) {
            min = Math.min(min, this.selectedRows[i]);
            ++i;
        }
        return min;
    }

    @Override
    public int getSelectionCount() {
        return this.selectedPaths.size();
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void clearSelection() {
        TreePath[] treePathsSelected = ProjectTreeSelectionModel.getTreePathArrayFromList(this.selectedPaths);
        if (treePathsSelected.length == 0) {
            return;
        }
        boolean[] areNew = new boolean[treePathsSelected.length];
        int i = 0;
        while (i < areNew.length) {
            areNew[i] = false;
            ++i;
        }
        TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, treePathsSelected, areNew, this.getLeadSelectionPath(), null);
        this.fireValueChanged(treeSelectionEvent);
        this.selectedPaths.clear();
    }

    private void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        for (TreeSelectionListener listener : this.treeSelectionListenerSet) {
            listener.valueChanged(treeSelectionEvent);
        }
    }

    @Override
    public void resetRowSelection() {
        this.selectedRows = (int[])(this.rowMapper != null ? this.rowMapper.getRowsForPaths(ProjectTreeSelectionModel.getTreePathArrayFromList(this.selectedPaths)) : null);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selectedPaths.isEmpty();
    }

    @Override
    public int[] getSelectionRows() {
        return this.selectedRows;
    }

    @Override
    public void setSelectionMode(int mode) {
        if (mode == this.selectionMode) {
            return;
        }
        switch (mode) {
            case 1: {
                this.selectionModeState = this.SINGLE_TREE_SELECTION_STATE;
                break;
            }
            case 4: {
                this.selectionModeState = this.DISCONTIGUOUS_TREE_SELECTION_STATE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Modo de sele\u00e7\u00e3o inv\u00e1lido. Use: 1 ou 4.");
            }
        }
        int oldMode = this.selectionMode;
        this.selectionMode = mode;
        PropertyChangeEvent event = new PropertyChangeEvent(this, SELECTION_MODE_PROPERTY, new Integer(oldMode), new Integer(mode));
        this.firePropertyChange(event);
        this.updateSelection();
    }

    private void firePropertyChange(PropertyChangeEvent event) {
        for (PropertyChangeListener listener : this.propertyChangeListenerSet) {
            listener.propertyChange(event);
        }
    }

    @Override
    public boolean isRowSelected(int row) {
        if (this.selectedRows == null) {
            return false;
        }
        int i = 0;
        while (i < this.selectedRows.length) {
            if (this.selectedRows[i] == row) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListenerSet.add(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListenerSet.remove(listener);
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.treeSelectionListenerSet.add(listener);
    }

    @Override
    public void removeTreeSelectionListener(TreeSelectionListener listener) {
        this.treeSelectionListenerSet.remove(listener);
    }

    @Override
    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    @Override
    public void setRowMapper(RowMapper newMapper) {
        this.rowMapper = newMapper;
        this.resetRowSelection();
    }

    @Override
    public TreePath getLeadSelectionPath() {
        if (this.selectedPaths.isEmpty()) {
            return null;
        }
        return (TreePath)this.selectedPaths.getLast();
    }

    @Override
    public TreePath getSelectionPath() {
        if (this.selectedPaths.isEmpty()) {
            return null;
        }
        return (TreePath)this.selectedPaths.getFirst();
    }

    @Override
    public TreePath[] getSelectionPaths() {
        return ProjectTreeSelectionModel.getTreePathArrayFromList(this.selectedPaths);
    }

    @Override
    public void addSelectionPath(TreePath path) {
        if (path == null) {
            return;
        }
        TreePath[] paths = new TreePath[]{path};
        this.addSelectionPaths(paths);
    }

    @Override
    public void removeSelectionPath(TreePath path) {
        if (path == null) {
            return;
        }
        TreePath[] paths = new TreePath[]{path};
        this.removeSelectionPaths(paths);
    }

    @Override
    public void setSelectionPath(TreePath path) {
        if (path == null) {
            return;
        }
        TreePath[] paths = new TreePath[]{path};
        this.setSelectionPaths(paths);
    }

    @Override
    public boolean isPathSelected(TreePath path) {
        return this.selectedPaths.contains((Object)path);
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        this.selectionModeState.addSelectionPaths(this.filterPaths(paths));
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        this.selectionModeState.removeSelectionPaths(this.filterPaths(paths));
    }

    @Override
    public void setSelectionPaths(TreePath[] paths) {
        this.selectionModeState.setSelectionPaths(this.filterPaths(paths));
    }

    private NoDuplicatesCollection<TreePath> filterPaths(TreePath[] paths) {
        NoDuplicatesCollection filteredPathsList = new NoDuplicatesCollection();
        if (paths != null) {
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                if (path != null) {
                    ProjectTreeNode treeNode = (ProjectTreeNode)path.getLastPathComponent();
                    ClientProjectFile projectFile = treeNode.getClientProjectFile();
                    if (this.filter == null || this.filter.accept(projectFile)) {
                        filteredPathsList.add((Object)path);
                    }
                }
                ++n2;
            }
        }
        return filteredPathsList;
    }

    private static TreePath[] getTreePathArrayFromList(NoDuplicatesCollection<TreePath> list) {
        return (TreePath[])list.toArray((Object[])new TreePath[list.size()]);
    }

    private final class SelectionModeStateDiscontiguous
    implements SelectionModeStateInterface {
        private SelectionModeStateDiscontiguous() {
        }

        @Override
        public void addSelectionPaths(NoDuplicatesCollection<TreePath> treePathCollection) {
            if (treePathCollection.isEmpty()) {
                return;
            }
            TreePath oldLeadSelectionPath = ProjectTreeSelectionModel.this.getLeadSelectionPath();
            ProjectTreeSelectionModel.this.selectedPaths.addAll(treePathCollection);
            ProjectTreeSelectionModel.this.resetRowSelection();
            TreePath[] paths = ProjectTreeSelectionModel.getTreePathArrayFromList((NoDuplicatesCollection<TreePath>)ProjectTreeSelectionModel.this.selectedPaths);
            boolean[] areNew = new boolean[paths.length];
            Arrays.fill(areNew, true);
            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, paths, areNew, oldLeadSelectionPath, ProjectTreeSelectionModel.this.getLeadSelectionPath());
            ProjectTreeSelectionModel.this.fireValueChanged(treeSelectionEvent);
        }

        @Override
        public void setSelectionPaths(NoDuplicatesCollection<TreePath> treePathCollection) {
            if (treePathCollection.isEmpty()) {
                return;
            }
            TreePath oldLeadSelectionPath = ProjectTreeSelectionModel.this.getLeadSelectionPath();
            NoDuplicatesCollection allPaths = new NoDuplicatesCollection((Collection)ProjectTreeSelectionModel.this.selectedPaths);
            allPaths.addAll(treePathCollection);
            ProjectTreeSelectionModel.this.selectedPaths.clear();
            ProjectTreeSelectionModel.this.selectedPaths.addAll(treePathCollection);
            ProjectTreeSelectionModel.this.resetRowSelection();
            TreePath[] paths = ProjectTreeSelectionModel.getTreePathArrayFromList((NoDuplicatesCollection<TreePath>)allPaths);
            boolean[] areNew = new boolean[paths.length];
            int i = 0;
            while (i < areNew.length) {
                areNew[i] = treePathCollection.contains((Object)paths[i]);
                ++i;
            }
            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, paths, areNew, oldLeadSelectionPath, ProjectTreeSelectionModel.this.getLeadSelectionPath());
            ProjectTreeSelectionModel.this.fireValueChanged(treeSelectionEvent);
        }

        @Override
        public void removeSelectionPaths(NoDuplicatesCollection<TreePath> treePathCollection) {
            if (treePathCollection.isEmpty()) {
                return;
            }
            TreePath oldSelectionPath = ProjectTreeSelectionModel.this.getLeadSelectionPath();
            TreePath[] oldSelectedPaths = ProjectTreeSelectionModel.getTreePathArrayFromList((NoDuplicatesCollection<TreePath>)ProjectTreeSelectionModel.this.selectedPaths);
            ProjectTreeSelectionModel.this.selectedPaths.removeAll(treePathCollection);
            ProjectTreeSelectionModel.this.resetRowSelection();
            boolean[] areNew = new boolean[oldSelectedPaths.length];
            int i = 0;
            while (i < areNew.length) {
                areNew[i] = !treePathCollection.contains((Object)oldSelectedPaths[i]);
                ++i;
            }
            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, oldSelectedPaths, areNew, oldSelectionPath, ProjectTreeSelectionModel.this.getLeadSelectionPath());
            ProjectTreeSelectionModel.this.fireValueChanged(treeSelectionEvent);
        }
    }

    private final class SelectionModeStateSingle
    implements SelectionModeStateInterface {
        private SelectionModeStateSingle() {
        }

        @Override
        public void addSelectionPaths(NoDuplicatesCollection<TreePath> treePathCollection) {
            this.setSelectionPaths(treePathCollection);
        }

        @Override
        public void setSelectionPaths(NoDuplicatesCollection<TreePath> treePathCollection) {
            boolean[] areNew;
            TreePath[] paths;
            if (treePathCollection.isEmpty()) {
                return;
            }
            TreePath oldLeadSelectionPath = ProjectTreeSelectionModel.this.getLeadSelectionPath();
            ProjectTreeSelectionModel.this.selectedPaths.clear();
            ProjectTreeSelectionModel.this.selectedPaths.addAll(treePathCollection);
            ProjectTreeSelectionModel.this.resetRowSelection();
            TreePath newLeadSelectionPath = ProjectTreeSelectionModel.this.getLeadSelectionPath();
            if (oldLeadSelectionPath != null) {
                if (oldLeadSelectionPath.equals(newLeadSelectionPath)) {
                    return;
                }
                paths = new TreePath[]{oldLeadSelectionPath, newLeadSelectionPath};
                boolean[] blArray = new boolean[2];
                blArray[1] = true;
                areNew = blArray;
            } else {
                paths = new TreePath[]{newLeadSelectionPath};
                areNew = new boolean[]{true};
            }
            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, paths, areNew, oldLeadSelectionPath, newLeadSelectionPath);
            ProjectTreeSelectionModel.this.fireValueChanged(treeSelectionEvent);
        }

        @Override
        public void removeSelectionPaths(NoDuplicatesCollection<TreePath> treePathCollection) {
            if (treePathCollection.isEmpty()) {
                return;
            }
            TreePath oldSelectionPath = ProjectTreeSelectionModel.this.getLeadSelectionPath();
            TreePath[] oldSelectedPaths = ProjectTreeSelectionModel.getTreePathArrayFromList((NoDuplicatesCollection<TreePath>)ProjectTreeSelectionModel.this.selectedPaths);
            ProjectTreeSelectionModel.this.selectedPaths.removeAll(treePathCollection);
            ProjectTreeSelectionModel.this.resetRowSelection();
            boolean[] areNew = new boolean[oldSelectedPaths.length];
            int i = 0;
            while (i < areNew.length) {
                areNew[i] = !treePathCollection.contains((Object)oldSelectedPaths[i]);
                ++i;
            }
            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, oldSelectedPaths, areNew, oldSelectionPath, ProjectTreeSelectionModel.this.getLeadSelectionPath());
            ProjectTreeSelectionModel.this.fireValueChanged(treeSelectionEvent);
        }
    }
}

