/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.project.AbstractProjectFileTransferHandler;
import csbase.client.project.ProjectTreeNode;
import csbase.logic.ClientProjectFile;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ProjectTreeTransferHandler
extends AbstractProjectFileTransferHandler {
    public ProjectTreeTransferHandler(Window ownerWindow, String ownerTitle) {
        super(ownerWindow, ownerTitle);
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavor) {
        if (!(c instanceof JTree)) {
            return false;
        }
        JTree tree = (JTree)c;
        if (tree.getEditingPath() != null) {
            return false;
        }
        return super.canImport(c, flavor);
    }

    @Override
    protected ClientProjectFile[] getFilesToExport(JComponent source) {
        JTree tree;
        TreePath[] path;
        if (source instanceof JTree && (path = (tree = (JTree)source).getSelectionPaths()).length > 0) {
            ClientProjectFile[] files = new ClientProjectFile[path.length];
            int inx = 0;
            while (inx < path.length) {
                ProjectTreeNode selectedNode = (ProjectTreeNode)path[inx].getLastPathComponent();
                files[inx] = selectedNode.getClientProjectFile();
                ++inx;
            }
            return files;
        }
        return null;
    }

    @Override
    protected ClientProjectFile getDestinationDirectory(JComponent destination) {
        if (destination instanceof JTree) {
            JTree tree = (JTree)destination;
            TreePath path = tree.getSelectionPath();
            ProjectTreeNode selectedNode = (ProjectTreeNode)path.getLastPathComponent();
            return selectedNode.getClientProjectFile();
        }
        return null;
    }
}

