/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import csbase.client.util.UserTarget;
import csbase.logic.UserOutline;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.selector.ContainerSelection;
import tecgraf.javautils.gui.selector.ContainerSelectionListener;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class UserContainerSelection {
    private ContainerSelection<UserTarget> selectableItems = null;
    private boolean enabled;
    private Vector<UserOutline> availableUsers;
    private Vector<UserOutline> selectedUsers;
    private boolean showTitles;

    public static JPanel getUserContainerSelection(boolean enabled, Vector<UserOutline> availableUsers, Vector<UserOutline> selectedUsers) {
        return new UserContainerSelection(enabled, availableUsers, selectedUsers).getPanel();
    }

    public JPanel getPanel() {
        ObjectTableProvider firstFormatter = this.getFormatForAvailableItems();
        ObjectTableProvider secondFormatter = this.getFormatForSelectedItems();
        this.selectableItems = this.showTitles ? new ContainerSelection(firstFormatter, secondFormatter, this.enabled, false, LNG.get((String)"IAS_AVAILABLE_USERS"), LNG.get((String)"IAS_SELECTED_USERS")) : new ContainerSelection(firstFormatter, secondFormatter, this.enabled, false);
        if (this.selectedUsers != null || this.selectedUsers.size() > 0) {
            this.availableUsers.removeAll(this.selectedUsers);
        }
        this.selectableItems.loadItems(UserTarget.toUserTarget(this.availableUsers), UserTarget.toUserTarget(this.selectedUsers));
        this.selectableItems.adjustTableColumns();
        return this.selectableItems.getPanel();
    }

    public Object[] getSelectedItems() {
        List selectedUsers = this.selectableItems.getSelectedItems();
        Object[] userIds = new Object[selectedUsers.size()];
        int i = 0;
        while (i < selectedUsers.size()) {
            userIds[i] = ((UserTarget)selectedUsers.get(i)).getUserId();
            ++i;
        }
        return userIds;
    }

    public Object getUserId(int index) {
        List users = this.selectableItems.getSelectedItems();
        if (users == null) {
            return null;
        }
        UserTarget user = (UserTarget)users.get(index);
        if (user == null) {
            return null;
        }
        return user.getUserId();
    }

    public void addContainerSelectionListener(ContainerSelectionListener l) {
        this.selectableItems.addContainerSelectionListener(l);
    }

    private ObjectTableProvider getFormatForAvailableItems() {
        return new DefaultObjectTableProvider(){

            public String[] getColumnNames() {
                return new String[]{LNG.get((String)"IAS_USER"), LNG.get((String)"IAS_USER_NAME")};
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{String.class, String.class};
            }

            public Object[] getCellValues(Object item) {
                UserTarget target = (UserTarget)item;
                if (target == null) {
                    return null;
                }
                Object[] format = new String[]{target.getLogin(), target.getName()};
                return format;
            }
        };
    }

    private ObjectTableProvider getFormatForSelectedItems() {
        return new DefaultObjectTableProvider(){

            public String[] getColumnNames() {
                return new String[]{LNG.get((String)"IAS_USER"), LNG.get((String)"IAS_USER_NAME")};
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{String.class, String.class};
            }

            public Object[] getCellValues(Object item) {
                UserTarget target = (UserTarget)item;
                if (target == null) {
                    return null;
                }
                Object[] format = new String[]{target.getLogin(), target.getName()};
                return format;
            }
        };
    }

    public ContainerSelection<UserTarget> getContainerSelection() {
        return this.selectableItems;
    }

    public UserContainerSelection(boolean enabled, Vector<UserOutline> availableUsers, Vector<UserOutline> selectedUsers) {
        this(enabled, availableUsers, selectedUsers, false);
    }

    public UserContainerSelection(boolean enabled, Vector<UserOutline> availableUsers, Vector<UserOutline> selectedUsers, boolean showTitles) {
        this.enabled = enabled;
        this.availableUsers = availableUsers;
        this.selectedUsers = selectedUsers;
        this.showTitles = showTitles;
    }

    public void setEnabled(boolean enabled) {
        this.selectableItems.setEnabled(enabled);
    }

    public void reset() {
        ArrayList allUsers = new ArrayList();
        if (this.selectableItems.hasAvailableItems()) {
            allUsers.addAll(this.selectableItems.getAvailableItems());
        }
        if (this.selectableItems.hasSelectedItems()) {
            allUsers.addAll(this.selectableItems.getSelectedItems());
        }
        this.selectableItems.clear();
        this.selectableItems.loadItems(allUsers);
    }
}

