/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel;

import csbase.client.Client;
import csbase.client.desktop.LocalTask;
import csbase.client.util.iostring.TextWriter;
import csbase.exception.OperationFailureException;
import csbase.exception.ParseException;
import csbase.logic.ClientFile;
import java.awt.Window;
import java.nio.charset.Charset;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.parsers.csv.CsvParser;

public class CSVFileUtils {
    public static void writeCSVFile(Window owner, String[][] contents, ClientFile file) throws OperationFailureException {
        try {
            String content = CSVFileUtils.generateCSVFileContent(contents);
            Client client = Client.getInstance();
            Charset charset = client.getSystemDefaultCharset();
            TextWriter.writeAllWithTask(owner, file, content, charset);
        }
        catch (Exception e) {
            throw new OperationFailureException((Throwable)e);
        }
    }

    public static String generateCSVFileContent(String[][] contents) {
        StringBuilder content = new StringBuilder();
        String lineSeparator = "\n";
        String valueSeparator = ",";
        String quote = "\"";
        String[][] stringArray = contents;
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            String[] values;
            String[] stringArray2 = values = stringArray[n2];
            int n3 = values.length;
            int n4 = 0;
            while (n4 < n3) {
                String value = stringArray2[n4];
                if (value != null) {
                    content.append("\"");
                    content.append(value);
                    content.append("\"");
                }
                content.append(",");
                ++n4;
            }
            content.append("\n");
            ++n2;
        }
        return content.toString();
    }

    public static String[][] readCSVFile(Window owner, final ClientFile file) throws OperationFailureException {
        Client client = Client.getInstance();
        final String lngPrefix = CSVFileUtils.class.getName();
        final Charset charset = client.getSystemDefaultCharset();
        LocalTask<String[][]> task = new LocalTask<String[][]>(){

            protected void performTask() throws Exception {
                CsvParser parser = new CsvParser();
                String[][] lines = parser.parse(file.getInputStream(), charset);
                if (lines.length > 0) {
                    int numParams = lines[0].length;
                    int i = 1;
                    while (i < lines.length) {
                        if (lines[i].length != numParams) {
                            throw new ParseException(LNG.get((String)(String.valueOf(lngPrefix) + ".read.task.invalidLine.error"), (Object[])new Object[]{i + 1, lines[i].length, numParams}));
                        }
                        ++i;
                    }
                }
                this.setResult(lines);
            }
        };
        if (!task.execute(owner, LNG.get((String)(String.valueOf(lngPrefix) + ".read.task.title")), LNG.get((String)(String.valueOf(lngPrefix) + ".read.task.message")))) {
            throw new OperationFailureException((Throwable)task.getError());
        }
        return (String[][])task.getResult();
    }
}

