/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel.columns;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.util.csvpanel.columns.ClientFileChooserTextPanel;
import csbase.client.util.csvpanel.columns.ColumnGenerator;
import csbase.client.util.csvpanel.columns.DirectoryListingColumnGenerator;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.logic.ClientFile;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;

public class DirectoryListingColumnGeneratorDialog
extends DesktopComponentDialog {
    private DirectoryListingColumnGenerator generator;
    private boolean confirmed = false;
    private ClientFileChooserTextPanel directoryChooserPanel;

    public DirectoryListingColumnGeneratorDialog(Window owner) {
        super(owner, DirectoryListingColumnGeneratorDialog.getString("title"));
        this.setDefaultCloseOperation(2);
        this.generator = null;
        this.createUI();
    }

    private void createUI() {
        JPanel mainPanel = this.createMainPanel();
        JPanel buttonPanel = this.createButtonPanel();
        this.add((Component)mainPanel, "Center");
        this.add((Component)buttonPanel, "South");
        this.center();
        this.pack();
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        JLabel directoryLabel = new JLabel(DirectoryListingColumnGeneratorDialog.getString("dir.label"));
        this.directoryChooserPanel = new ClientFileChooserTextPanel(this, null, ClientFileChooserType.OPEN, ClientFileChooserSelectionMode.DIRECTORIES_ONLY, ClientFileChooserTextPanel.ClientFileLocation.ANY);
        mainPanel.add((Component)directoryLabel, "Before");
        mainPanel.add((Component)this.directoryChooserPanel, "After");
        return mainPanel;
    }

    private JPanel createButtonPanel() {
        JButton okButton = new JButton(DirectoryListingColumnGeneratorDialog.getString("ok.button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DirectoryListingColumnGeneratorDialog.this.applyValues()) {
                    DirectoryListingColumnGeneratorDialog.this.confirmed = true;
                    DirectoryListingColumnGeneratorDialog.this.setVisible(false);
                }
            }
        });
        JButton cancelButton = new JButton(DirectoryListingColumnGeneratorDialog.getString("cancel.button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryListingColumnGeneratorDialog.this.confirmed = false;
                DirectoryListingColumnGeneratorDialog.this.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)okButton, "Before");
        buttonPanel.add((Component)cancelButton, "After");
        return buttonPanel;
    }

    private boolean applyValues() {
        ClientFile directory = this.directoryChooserPanel.getSelectedFile();
        if (directory != null) {
            this.generator = new DirectoryListingColumnGenerator(this, directory);
        }
        return true;
    }

    protected static String getString(String key) {
        return LNG.get((String)(String.valueOf(DirectoryListingColumnGeneratorDialog.class.getName()) + "." + key));
    }

    protected static String getString(String key, Object ... args) {
        return MessageFormat.format(DirectoryListingColumnGeneratorDialog.getString(key), args);
    }

    public ColumnGenerator<?> getColumnGenerator() {
        if (!this.confirmed) {
            return null;
        }
        return this.generator;
    }
}

