/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel.columns;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.util.csvpanel.columns.ColumnGenerator;
import csbase.client.util.csvpanel.columns.SequentialColumnGenerator;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

public class SequentialColumnGeneratorDialog
extends DesktopComponentDialog {
    private JLabel prefixLabel;
    private JTextField prefixField;
    private JLabel sufixLabel;
    private JTextField sufixField;
    private JLabel stepLabel;
    private JTextField stepField;
    private JLabel startValueLabel;
    private JTextField startValueField;
    private SequentialColumnGenerator generator;
    boolean confirmed = false;

    public SequentialColumnGeneratorDialog(Window owner) {
        super(owner, SequentialColumnGeneratorDialog.getString("title"));
        this.setDefaultCloseOperation(2);
        this.generator = new SequentialColumnGenerator();
        this.createUI();
    }

    private void createUI() {
        JPanel mainPanel = this.createMainPanel();
        JPanel buttonPanel = this.createButtonPanel();
        this.add((Component)mainPanel, "Center");
        this.add((Component)buttonPanel, "South");
        this.center();
        this.pack();
    }

    private JPanel createMainPanel() {
        this.prefixLabel = new JLabel(SequentialColumnGeneratorDialog.getString("prefix.label"));
        this.prefixField = new JTextField(this.generator.getPrefix());
        this.sufixLabel = new JLabel(SequentialColumnGeneratorDialog.getString("sufix.label"));
        this.sufixField = new JTextField(this.generator.getSufix());
        this.stepLabel = new JLabel(SequentialColumnGeneratorDialog.getString("step.label"));
        this.stepField = new JTextField(String.valueOf(this.generator.getStep()));
        this.startValueLabel = new JLabel(SequentialColumnGeneratorDialog.getString("startValue.label"));
        this.startValueField = new JTextField(String.valueOf(this.generator.getStartValue()));
        JComponent[][] rows = new JComponent[][]{{this.prefixLabel, this.prefixField}, {this.sufixLabel, this.sufixField}, {this.stepLabel, this.stepField}, {this.startValueLabel, this.startValueField}};
        JPanel mainPanel = GUIUtils.createBasicGridPanel((JComponent[][])rows);
        return mainPanel;
    }

    private JPanel createButtonPanel() {
        JButton okButton = new JButton(SequentialColumnGeneratorDialog.getString("ok.button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SequentialColumnGeneratorDialog.this.applyValues()) {
                    SequentialColumnGeneratorDialog.this.confirmed = true;
                    SequentialColumnGeneratorDialog.this.setVisible(false);
                }
            }
        });
        JButton cancelButton = new JButton(SequentialColumnGeneratorDialog.getString("cancel.button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequentialColumnGeneratorDialog.this.confirmed = false;
                SequentialColumnGeneratorDialog.this.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)okButton, "Before");
        buttonPanel.add((Component)cancelButton, "After");
        return buttonPanel;
    }

    private boolean applyValues() {
        String stepText;
        String startValueText = this.startValueField.getText();
        if (!startValueText.trim().isEmpty()) {
            try {
                Integer startValue = Integer.valueOf(startValueText);
                this.generator.setStartValue(startValue);
            }
            catch (NumberFormatException e) {
                StandardDialogs.showErrorDialog((Component)this, (String)this.getTitle(), (String)SequentialColumnGeneratorDialog.getString("error", startValueText, this.startValueLabel.getText()));
                return false;
            }
        }
        if (!(stepText = this.stepField.getText()).trim().isEmpty()) {
            try {
                Integer stepValue = Integer.valueOf(stepText);
                this.generator.setStep(stepValue);
            }
            catch (NumberFormatException e) {
                StandardDialogs.showErrorDialog((Component)this, (String)this.getTitle(), (String)SequentialColumnGeneratorDialog.getString("error", stepText, this.stepLabel.getText()));
                return false;
            }
        }
        this.generator.setPrefix(this.prefixField.getText());
        this.generator.setSufix(this.sufixField.getText());
        return true;
    }

    private static String getString(String key) {
        return LNG.get((String)(String.valueOf(SequentialColumnGeneratorDialog.class.getName()) + "." + key));
    }

    private static String getString(String key, Object ... args) {
        return MessageFormat.format(SequentialColumnGeneratorDialog.getString(key), args);
    }

    public ColumnGenerator<?> getColumnGenerator() {
        if (!this.confirmed) {
            return null;
        }
        return this.generator;
    }
}

