/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser.fileparentcombopanel;

import csbase.client.ClientLocalFile;
import csbase.client.util.filechooser.fileparentcombopanel.ClientFileParentComboChooseListener;
import csbase.client.util.filechooser.fileparentcombopanel.ClientFileParentComboRenderer;
import csbase.client.util.filechooser.util.ClientFileChooserUtils;
import csbase.logic.ClientFile;
import csbase.logic.ClientFileType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class ClientFileParentComboPanel
extends JPanel {
    private ClientFile directory = null;
    private final JComboBox combo = new JComboBox();
    private final List<ClientFileParentComboChooseListener> listeners = new ArrayList<ClientFileParentComboChooseListener>();

    public final void setLeafDirectory(ClientFile directory) {
        int size;
        if (!directory.canExecute() || !directory.canRead()) {
            return;
        }
        this.directory = directory;
        ArrayList<ClientFile> ancestors = new ArrayList<ClientFile>();
        ClientFile elem = directory;
        while (elem != null) {
            ancestors.add(elem);
            elem = elem.getParent();
        }
        Collections.reverse(ancestors);
        if (directory.getClientFileType() == ClientFileType.LOCAL) {
            List<ClientLocalFile> roots = ClientFileChooserUtils.getLocalRootDirectories();
            for (ClientLocalFile root : roots) {
                if (ancestors.contains(root)) continue;
                ancestors.add(root);
            }
        }
        if ((size = ancestors.size()) > 0) {
            ClientFile[] array = ancestors.toArray(new ClientFile[size]);
            this.combo.setModel(new DefaultComboBoxModel<ClientFile>(array));
            this.combo.setEnabled(true);
            this.combo.setSelectedItem(directory);
        } else {
            this.combo.setModel(new DefaultComboBoxModel());
            this.combo.setEnabled(false);
        }
    }

    public final ClientFile getDirectory() {
        return this.directory;
    }

    public ClientFileParentComboPanel() {
        this.setLayout(new BorderLayout());
        this.combo.setRenderer(new ClientFileParentComboRenderer());
        this.add((Component)this.combo, "Center");
        this.addChooseListener();
    }

    public void addParentsComboPanelChooseListener(ClientFileParentComboChooseListener clientProjectFileParentComboChooseListener) {
        this.listeners.add(clientProjectFileParentComboChooseListener);
    }

    public void delParentsComboPanelChooseListener(ClientFileParentComboChooseListener listener) {
        this.listeners.remove(listener);
    }

    private void addChooseListener() {
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFile item = (ClientFile)ClientFileParentComboPanel.this.combo.getSelectedItem();
                if (item == null || item.equals(ClientFileParentComboPanel.this.directory)) {
                    return;
                }
                for (ClientFileParentComboChooseListener l : ClientFileParentComboPanel.this.listeners) {
                    l.parentChosen(ClientFileParentComboPanel.this, item);
                }
            }
        });
    }
}

