/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser.fileparentcombopanel;

import csbase.client.util.filechooser.images.ChooserImages;
import csbase.client.util.filechooser.util.ClientFileChooserUtils;
import csbase.logic.ClientFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

class ClientFileParentComboRenderer
extends DefaultListCellRenderer {
    private static final Font DEFAULT_FONT = new JLabel().getFont();

    ClientFileParentComboRenderer() {
    }

    private int getDepth(ClientFile clientFile) {
        if (ClientFileChooserUtils.isLocalRootDirectory(clientFile) || ClientFileChooserUtils.isProjectHomeDirectory(clientFile)) {
            return 0;
        }
        int depth = 0;
        ClientFile f = clientFile;
        while (f != null) {
            ++depth;
            f = f.getParent();
        }
        return depth;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        JLabel label = (JLabel)component;
        ClientFile directory = (ClientFile)value;
        label.setIcon(ChooserImages.DIRECTORY_ICON);
        label.setForeground(Color.black);
        label.setFont(DEFAULT_FONT);
        label.setHorizontalAlignment(2);
        int left = this.getDepth(directory) * 10;
        label.setBorder(BorderFactory.createEmptyBorder(0, left, 0, 0));
        if (directory == null) {
            label.setText(null);
            label.setIcon(null);
        } else {
            String dirName = ClientFileChooserUtils.getDirectoryName(directory);
            label.setText(dirName);
            ImageIcon icon = ClientFileChooserUtils.getDirectoryImageIcon(directory);
            label.setIcon(icon);
        }
        return label;
    }
}

