/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui;

import java.awt.Component;
import java.awt.Dimension;

public class ComponentUtilities {
    public static Dimension getMaxPreferredSize(Component ... components) {
        double width = 0.0;
        double height = 0.0;
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component aComponent = componentArray[n2];
            Dimension preferredSize = aComponent.getPreferredSize();
            width = Math.max(width, preferredSize.getWidth());
            height = Math.max(height, preferredSize.getHeight());
            ++n2;
        }
        return new Dimension((int)width, (int)height);
    }

    public static void setMaxPreferredSize(Component ... components) {
        Dimension preferredSize = ComponentUtilities.getMaxPreferredSize(components);
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component aComponent = componentArray[n2];
            aComponent.setPreferredSize(preferredSize);
            ++n2;
        }
    }

    public static void setMaxPreferredWidth(Component ... components) {
        Dimension maxPreferredSize = ComponentUtilities.getMaxPreferredSize(components);
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component aComponent = componentArray[n2];
            Dimension preferredSize = aComponent.getPreferredSize();
            preferredSize.width = maxPreferredSize.width;
            aComponent.setPreferredSize(preferredSize);
            ++n2;
        }
    }

    public static void setMaxPreferredHeight(Component ... components) {
        Dimension maxPreferredSize = ComponentUtilities.getMaxPreferredSize(components);
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component aComponent = componentArray[n2];
            Dimension preferredSize = aComponent.getPreferredSize();
            preferredSize.height = maxPreferredSize.height;
            aComponent.setPreferredSize(preferredSize);
            ++n2;
        }
    }
}

