/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.table;

import csbase.client.util.table.CellModel;
import csbase.client.util.table.CellModelListener;
import csbase.client.util.table.CellView;
import csbase.client.util.table.RowModel;
import csbase.client.util.table.RowModelListener;
import csbase.client.util.table.RowValueFactory;
import csbase.client.util.table.TableColumn;
import csbase.client.util.table.TableListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public final class Table<R> {
    private AbstractTableModel abstractTableModel;
    private JButton addButton;
    private List<TableColumn<R>> columns;
    private boolean isEnabled;
    private JTable jtable;
    private List<TableListener<R>> listeners = new LinkedList<TableListener<R>>();
    private JButton removeAllButton;
    private JButton removeButton;
    private RowModel<R> rowModel;
    private RowValueFactory<R> rowValueFactory;
    private JPanel view;
    private Integer visibleRowCount;
    private Integer minRowCount;
    private Integer maxRowCount;

    public Table(RowModel<R> rowModel, List<TableColumn<R>> columns) {
        this(null, rowModel, columns, null, null, null);
    }

    public Table(RowValueFactory<R> rowValueFactory, RowModel<R> rowModel, List<TableColumn<R>> columns, Integer visibleRowCount, Integer minRowCount, Integer maxRowCount) {
        this.rowValueFactory = rowValueFactory;
        this.visibleRowCount = visibleRowCount;
        this.minRowCount = minRowCount;
        this.maxRowCount = maxRowCount;
        this.setRowModel(rowModel);
        this.setColumns(columns);
        this.createAbstractTableModel();
        this.createCells();
        this.createCellModelListeners();
        this.createJTable();
        if (minRowCount != null) {
            int lastRow = this.getRowCount();
            while (lastRow < minRowCount) {
                this.addRow(rowValueFactory.create(lastRow));
                lastRow = this.getRowCount();
            }
        }
        this.view = new JPanel(new BorderLayout());
        this.view.add((Component)new JScrollPane(this.jtable), "Center");
        if (rowValueFactory != null) {
            JPanel buttonPanel1 = this.createButtonPanel();
            this.view.add((Component)buttonPanel1, "East");
            this.addTableListener(new TableListener<R>(){

                @Override
                public void rowWasAdded(R newRowValue) {
                    Table.this.updateAddButton();
                    Table.this.updateRemoveButton();
                    Table.this.updateRemoveAllButton();
                }

                @Override
                public void rowWasRemoved(int rowIndex) {
                    Table.this.updateAddButton();
                    Table.this.updateRemoveButton();
                    Table.this.updateRemoveAllButton();
                }
            });
        }
        this.setEnabled(true);
    }

    public void addRow(R rowValue) {
        this.rowModel.addRow(rowValue);
    }

    public void addTableListener(TableListener<R> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getRowCount() {
        return this.rowModel.getRowCount();
    }

    public List<R> getRowValues() {
        return this.rowModel.getRows();
    }

    public String getToolTipText() {
        return this.jtable.getToolTipText();
    }

    public JComponent getView() {
        return this.view;
    }

    public boolean hasRows() {
        return this.getRowCount() != 0;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void removeRow(int rowIndex) {
        this.assertRowIndex(rowIndex);
        this.rowModel.removeRow(rowIndex);
    }

    public boolean removeTableListener(TableListener<R> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        return this.listeners.remove(listener);
    }

    public void selectCell(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            String message = String.format("\u00cdndice da linha (%d) fora da faixa esperada (0 a %d).", rowIndex, this.getRowCount());
            throw new IllegalArgumentException(message);
        }
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            String message = String.format("\u00cdndice da linha (%d) fora da faixa esperada (0 a %d).", columnIndex, this.getColumnCount() - 1);
            throw new IllegalArgumentException(message);
        }
        this.jtable.changeSelection(rowIndex, columnIndex, false, false);
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.jtable.setEnabled(isEnabled);
        this.view.setEnabled(isEnabled);
        this.updateAddButton();
        this.updateRemoveButton();
        this.updateRemoveAllButton();
    }

    public void setToolTipText(String toolTipText) {
        this.jtable.setToolTipText(toolTipText);
    }

    private void adjustRowHeight() {
        int rowHeight = 0;
        int columnIndex = 0;
        while (columnIndex < this.getColumnCount()) {
            TableColumn<R> column = this.getColumn(columnIndex);
            int rowIndex = 0;
            while (rowIndex < this.getRowCount()) {
                CellView cell = column.getCellView(rowIndex);
                JComponent cellView = cell.getView();
                int cellHeight = (int)cellView.getPreferredSize().getHeight();
                rowHeight = Math.max(rowHeight, cellHeight);
                ++rowIndex;
            }
            ++columnIndex;
        }
        this.jtable.setRowHeight(rowHeight);
    }

    private void assertRowIndex(int rowIndex) {
        if (rowIndex < 0 || this.getRowCount() <= rowIndex) {
            throw new IllegalArgumentException(String.format("\u00cdndice de linha fora da faixa esperada.\nFaixa esperada 0 a %d.", this.getRowCount() - 1));
        }
    }

    private void createAbstractTableModel() {
        this.abstractTableModel = new AbstractTableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return Object.class;
            }

            @Override
            public int getColumnCount() {
                return Table.this.columns.size();
            }

            @Override
            public String getColumnName(int columnIndex) {
                TableColumn column = Table.this.getColumn(columnIndex);
                return column.getTitle();
            }

            @Override
            public int getRowCount() {
                return Table.this.rowModel.getRowCount();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                TableColumn column = Table.this.getColumn(columnIndex);
                CellModel cellModel = column.getCellModel(rowIndex);
                return cellModel.getValue();
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                TableColumn column = Table.this.getColumn(columnIndex);
                return column.isEditable();
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                TableColumn column = Table.this.getColumn(columnIndex);
                CellModel cellModel = column.getCellModel(rowIndex);
                cellModel.setValue(aValue);
            }
        };
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.createAddButton();
        this.createRemoveButton();
        this.createRemoveAllButton();
        int bIns = 3;
        buttonPanel.add((Component)this.addButton, new GBC(0, 0).center().insets(3));
        buttonPanel.add((Component)this.removeButton, new GBC(0, 1).center().insets(3));
        buttonPanel.add((Component)this.removeAllButton, new GBC(0, 2).center().insets(3));
        JComponent[] array = new JComponent[]{this.addButton, this.removeButton, this.removeAllButton};
        GUIUtils.matchPreferredSizes((JComponent[])array);
        int brd = 5;
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return buttonPanel;
    }

    private void createCell(int rowIndex, R rowValue) {
        for (TableColumn<R> column : this.columns) {
            column.createCell(rowIndex, rowValue);
        }
    }

    private void createCellModelListener(int rowIndex) {
        for (TableColumn<R> column : this.columns) {
            CellModel cellModel = column.getCellModel(rowIndex);
            cellModel.addCellModelListener(new CellModelListener(){

                @Override
                public void valueWasChanged(CellModel cm) {
                    Table.this.abstractTableModel.fireTableDataChanged();
                }
            });
        }
    }

    private void createCellModelListeners() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.createCellModelListener(i);
            ++i;
        }
    }

    private void createCells() {
        int rowIndex = 0;
        while (rowIndex < this.getRowCount()) {
            R rowValue = this.rowModel.getRow(rowIndex);
            this.createCell(rowIndex, rowValue);
            ++rowIndex;
        }
    }

    private void createJTable() {
        this.jtable = new JTable(this.abstractTableModel){

            @Override
            public void editingCanceled(ChangeEvent e) {
                super.removeEditor();
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                TableCellEditor editor = this.getCellEditor();
                if (editor != null) {
                    Object value = editor.getCellEditorValue();
                    this.setValueAt(value, this.editingRow, this.editingColumn);
                    super.removeEditor();
                }
            }

            @Override
            public void removeEditor() {
                if (this.isEditing()) {
                    this.getCellEditor().stopCellEditing();
                }
                super.removeEditor();
            }
        };
        this.jtable.setDefaultRenderer(Object.class, this.createTableCellRenderer());
        this.jtable.setDefaultEditor(Object.class, this.createTableCellEditor());
        this.jtable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.jtable.setColumnSelectionAllowed(false);
        if (this.rowValueFactory != null) {
            this.jtable.setCellSelectionEnabled(false);
            this.jtable.setRowSelectionAllowed(true);
        } else {
            this.jtable.setRowSelectionAllowed(false);
            this.jtable.setCellSelectionEnabled(true);
        }
        this.jtable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Table.this.updateRemoveButton();
            }
        });
        if (!this.rowModel.isEmpty()) {
            this.adjustRowHeight();
        }
        if (this.rowValueFactory == null) {
            Dimension tableSize = this.jtable.getPreferredSize();
            Dimension viewPortSize = this.jtable.getPreferredScrollableViewportSize();
            double height = Math.min(tableSize.getHeight(), viewPortSize.getHeight());
            Dimension dimension = new Dimension();
            dimension.setSize(viewPortSize.getWidth(), height);
            this.jtable.setPreferredScrollableViewportSize(dimension);
        } else {
            int rowHeight = this.jtable.getRowHeight();
            int visibleRows = this.visibleRowCount != null ? this.visibleRowCount : 5;
            int height = visibleRows * rowHeight - visibleRows;
            int width = (int)this.jtable.getPreferredSize().getWidth();
            this.jtable.setPreferredScrollableViewportSize(new Dimension(width, height));
        }
    }

    private void createRemoveAllButton() {
        String label = LNG.get((String)"Table.remove.all.button");
        this.removeAllButton = new JButton(new AbstractAction(label){

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.removeAllRows();
            }
        });
        this.updateRemoveAllButton();
    }

    private void createRemoveButton() {
        String label = LNG.get((String)"Table.remove.button");
        this.removeButton = new JButton(new AbstractAction(label){

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.removeSelectedRows();
            }
        });
        this.updateRemoveButton();
    }

    private void createAddButton() {
        String label = LNG.get((String)"Table.add.button");
        this.addButton = new JButton(new AbstractAction(label){

            @Override
            public void actionPerformed(ActionEvent e) {
                Table.this.addRow(Table.this.rowValueFactory.create(Table.this.getRowCount()));
            }
        });
        this.updateAddButton();
    }

    private TableCellEditor createTableCellEditor() {
        return new TableCellEditor(){
            private TableColumn<R> currentColumn;
            private CellView currentCellView;
            private List<CellEditorListener> editListeners;
            {
                this.currentColumn = Table.this.getColumn(0);
                this.editListeners = new ArrayList<CellEditorListener>();
            }

            @Override
            public void addCellEditorListener(CellEditorListener l) {
                this.editListeners.add(l);
            }

            @Override
            public void cancelCellEditing() {
                int i = 0;
                while (i < this.editListeners.size()) {
                    CellEditorListener listener = this.editListeners.get(i);
                    listener.editingCanceled(new ChangeEvent(this));
                    ++i;
                }
            }

            @Override
            public Object getCellEditorValue() {
                return this.currentCellView.getValue();
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int columnIndex) {
                this.currentColumn = Table.this.getColumn(columnIndex);
                this.currentCellView = this.currentColumn.getCellView(rowIndex);
                Table.this.updateCellViewColors(this.currentCellView, false, this.currentColumn.isEditable());
                this.currentCellView.setFocus(true);
                this.currentCellView.startEditing();
                JComponent cellView = this.currentCellView.getView();
                if (this.currentCellView.getTip() != null) {
                    cellView.setToolTipText(this.currentCellView.getTip());
                }
                return cellView;
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return true;
            }

            @Override
            public void removeCellEditorListener(CellEditorListener l) {
                this.editListeners.remove(l);
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return true;
            }

            @Override
            public boolean stopCellEditing() {
                if (!this.currentCellView.validate()) {
                    return false;
                }
                this.currentCellView.stopEditing();
                int i = 0;
                while (i < this.editListeners.size()) {
                    CellEditorListener listener = this.editListeners.get(i);
                    listener.editingStopped(new ChangeEvent(this));
                    ++i;
                }
                return true;
            }
        };
    }

    private TableCellRenderer createTableCellRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
                TableColumn column = Table.this.getColumn(columnIndex);
                CellView cellView = column.getCellView(rowIndex);
                boolean isEditable = column.isEditable();
                Table.this.updateCellViewColors(cellView, isSelected, isEditable);
                cellView.setFocus(hasFocus);
                if (!cellView.isEditing()) {
                    cellView.setValue(value);
                }
                JComponent vw = cellView.getView();
                return vw;
            }
        };
    }

    private TableColumn<R> getColumn(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    private boolean hasSelectedRows() {
        return this.jtable.getSelectedRowCount() != 0;
    }

    private void removeAllRows() {
        while (!this.rowModel.isEmpty()) {
            this.removeRow(0);
        }
    }

    private void removeSelectedRows() {
        int rowIndex = 0;
        while (rowIndex < this.getRowCount()) {
            if (this.jtable.isRowSelected(rowIndex)) {
                this.removeRow(rowIndex);
                continue;
            }
            ++rowIndex;
        }
    }

    private void selectRow(int rowIndex) {
        this.jtable.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
    }

    private void setColumns(List<TableColumn<R>> columns) {
        if (columns == null) {
            throw new IllegalArgumentException("O par\u00e2metro columns est\u00e1 nulo.");
        }
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("O par\u00e2metro columns est\u00e1 vazio.");
        }
        this.columns = new ArrayList<TableColumn<R>>(columns);
    }

    private void setRowModel(RowModel<R> rowModel) {
        if (rowModel == null) {
            throw new IllegalArgumentException("O par\u00e2metro rowModel est\u00e1 nulo.");
        }
        this.rowModel = rowModel;
        rowModel.addRowModelListener(new RowModelListener<R>(){

            @Override
            public void rowWasAdded(R newRowValue, int newRowIndex) {
                Table.this.createCell(newRowIndex, newRowValue);
                Table.this.createCellModelListener(newRowIndex);
                Table.this.abstractTableModel.fireTableRowsInserted(newRowIndex, newRowIndex);
                Table.this.adjustRowHeight();
                Table.this.selectRow(newRowIndex);
                for (TableListener listener : Table.this.listeners) {
                    listener.rowWasAdded(newRowValue);
                }
            }

            @Override
            public void rowWasRemoved(R oldRowValue, int oldRowIndex) {
                for (TableColumn column : Table.this.columns) {
                    column.removeCell(oldRowIndex);
                }
                Table.this.abstractTableModel.fireTableRowsDeleted(oldRowIndex, oldRowIndex);
                for (TableListener listener : Table.this.listeners) {
                    listener.rowWasRemoved(oldRowIndex);
                }
            }
        });
    }

    private void updateCellViewColors(CellView cellView, boolean isSelected, boolean isEditable) {
        if (isSelected) {
            cellView.setForegroundColor(this.jtable.getSelectionForeground());
            cellView.setBackgroundColor(this.jtable.getSelectionBackground());
        } else if (isEditable) {
            cellView.setForegroundColor(this.jtable.getForeground());
            cellView.setBackgroundColor(this.jtable.getBackground());
        } else {
            cellView.setForegroundColor(this.jtable.getForeground());
            Container component = this.jtable.getParent();
            if (component == null) {
                component = this.jtable;
            }
            cellView.setBackgroundColor(component.getBackground());
        }
    }

    private void updateRemoveAllButton() {
        if (this.removeAllButton != null) {
            boolean canRemoveAll = this.canRemoveAll();
            this.removeAllButton.setEnabled(canRemoveAll);
        }
    }

    private boolean canRemoveAll() {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.hasRows()) {
            return false;
        }
        return this.minRowCount == null || this.minRowCount <= 0;
    }

    private boolean canRemove() {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.hasSelectedRows()) {
            return false;
        }
        int nRows = this.getRowCount();
        return this.minRowCount == null || nRows != this.minRowCount;
    }

    private boolean canAdd() {
        if (!this.isEnabled()) {
            return false;
        }
        int nRows = this.getRowCount();
        return this.maxRowCount == null || nRows != this.maxRowCount;
    }

    private void updateRemoveButton() {
        if (this.removeButton != null) {
            boolean canRemove = this.canRemove();
            this.removeButton.setEnabled(canRemove);
        }
    }

    private void updateAddButton() {
        if (this.addButton != null) {
            boolean canAdd = this.canAdd();
            this.addButton.setEnabled(canAdd);
        }
    }
}

