/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.table;

import csbase.client.util.table.CellModel;
import csbase.client.util.table.CellModelFactory;
import csbase.client.util.table.CellModelListener;
import csbase.client.util.table.CellView;
import csbase.client.util.table.CellViewFactory;
import csbase.client.util.table.ReflectionCellModelFactory;
import csbase.client.util.table.ReflectionCellViewFactory;
import java.util.HashMap;
import java.util.Map;

public final class TableColumn<R> {
    private CellModelFactory<R> cellModelFactory;
    private Map<Integer, CellModel> cellModelsByRowIndex = new HashMap<Integer, CellModel>();
    private Map<Integer, CellView> cellViewsByRowIndex = new HashMap<Integer, CellView>();
    private CellViewFactory cellViewFactory;
    private String title;
    private boolean isEditable;

    public TableColumn(String title, boolean isEditable, CellModelFactory<R> cellModelFactory, CellViewFactory cellViewFactory) {
        this.isEditable = isEditable;
        this.setCellModelFactory(cellModelFactory);
        this.setCellViewFactory(cellViewFactory);
        this.setTitle(title);
    }

    public TableColumn(String title, boolean isEditable, Class<R> rowClass, Class<? extends CellModel> cellModelClass, CellViewFactory cellViewFactory) {
        this(title, isEditable, new ReflectionCellModelFactory<R>(rowClass, cellModelClass), cellViewFactory);
    }

    public TableColumn(String title, boolean isEditable, CellModelFactory<R> cellModelFactory, Class<? extends CellView> cellViewClass) {
        this(title, isEditable, cellModelFactory, new ReflectionCellViewFactory(cellViewClass));
    }

    public TableColumn(String title, boolean isEditable, Class<R> rowClass, Class<? extends CellModel> cellModelClass, Class<? extends CellView> cellViewClass) {
        this(title, isEditable, new ReflectionCellModelFactory<R>(rowClass, cellModelClass), new ReflectionCellViewFactory(cellViewClass));
    }

    public void createCell(int rowIndex, R rowValue) {
        CellModel cellModel = this.createCellModel(rowValue);
        final CellView cellView = this.createCellView();
        cellModel.addCellModelListener(new CellModelListener(){

            @Override
            public void valueWasChanged(CellModel cellModel) {
                cellView.setValue(cellModel.getValue());
            }
        });
        this.cellModelsByRowIndex.put(rowIndex, cellModel);
        this.cellViewsByRowIndex.put(rowIndex, cellView);
    }

    public CellModel getCellModel(int rowIndex) {
        if (rowIndex < 0 || this.cellModelsByRowIndex.size() <= rowIndex) {
            throw new IllegalArgumentException(String.format("\u00cdndice de linha fora da faixa esperada.\n\u00cdndice: %d.\nM\u00ednimo: 0.\nM\u00e1ximo: %d.", rowIndex, this.cellViewsByRowIndex.size() - 1));
        }
        return this.cellModelsByRowIndex.get(rowIndex);
    }

    public CellView getCellView(int rowIndex) {
        if (rowIndex < 0 || this.cellViewsByRowIndex.size() <= rowIndex) {
            throw new IllegalArgumentException(String.format("\u00cdndice de linha fora da faixa esperada.\n\u00cdndice: %d.\nM\u00ednimo: 0.\nM\u00e1ximo: %d.", rowIndex, this.cellViewsByRowIndex.size() - 1));
        }
        return this.cellViewsByRowIndex.get(rowIndex);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void removeCell(int rowIndex) {
        if (rowIndex < 0 || this.cellModelsByRowIndex.size() <= rowIndex) {
            throw new IllegalArgumentException(String.format("\u00cdndice de linha fora da faixa esperada.\n\u00cdndice: %d.\nM\u00ednimo: 0.\nM\u00e1ximo: %d.", rowIndex, this.cellViewsByRowIndex.size() - 1));
        }
        this.cellModelsByRowIndex.remove(rowIndex);
        this.cellViewsByRowIndex.remove(rowIndex);
        int rowCount = this.cellViewsByRowIndex.size();
        int currentRowIndex = rowIndex + 1;
        while (currentRowIndex <= rowCount) {
            CellModel cellModel = this.cellModelsByRowIndex.get(currentRowIndex);
            this.cellModelsByRowIndex.put(currentRowIndex - 1, cellModel);
            CellView cellView = this.cellViewsByRowIndex.get(currentRowIndex);
            this.cellViewsByRowIndex.put(currentRowIndex - 1, cellView);
            ++currentRowIndex;
        }
    }

    public String toString() {
        return this.title;
    }

    private CellModel createCellModel(R rowValue) {
        return this.cellModelFactory.create(rowValue);
    }

    private CellView createCellView() {
        return this.cellViewFactory.create();
    }

    private void setCellModelFactory(CellModelFactory<R> cellModelFactory) {
        if (cellModelFactory == null) {
            throw new IllegalArgumentException("O par\u00e2metro cellModelFactory est\u00e1 nulo.");
        }
        this.cellModelFactory = cellModelFactory;
    }

    private void setCellViewFactory(CellViewFactory cellViewFactory) {
        if (cellViewFactory == null) {
            throw new IllegalArgumentException("O par\u00e2metro cellViewFactory est\u00e1 nulo.");
        }
        this.cellViewFactory = cellViewFactory;
    }

    private void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("O par\u00e2metro title est\u00e1 nulo.");
        }
        this.title = title;
    }
}

