/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.table;

import csbase.client.util.table.AbstractCellView;
import csbase.client.util.table.Converter;
import csbase.client.util.table.Validator;
import csbase.exception.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFieldCellView
extends AbstractCellView {
    private Converter converter;
    private JTextField textField;
    private List<Validator> validators;

    public TextFieldCellView() {
        this(HorizontalAlignment.LEFT, null, new Validator[0]);
    }

    public TextFieldCellView(HorizontalAlignment horizontalAlignment, Converter converter, Validator ... validators) {
        this.setValidators(validators);
        this.setConverter(converter);
        this.textField = new JTextField();
        this.textField.setBorder(null);
        this.textField.getDocument().addDocumentListener(this.createDocumentListener());
        if (horizontalAlignment == null) {
            horizontalAlignment = HorizontalAlignment.getDefault();
        }
        this.textField.setHorizontalAlignment(horizontalAlignment.getSwingConstant());
    }

    @Override
    public String getTip() {
        return this.getValidationErrorMessage();
    }

    @Override
    public Object getValue() {
        String text = this.textField.getText();
        if (text.length() == 0) {
            return null;
        }
        try {
            return this.converter.convertFromView(text);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public JComponent getView() {
        return this.textField;
    }

    @Override
    public void setFocus(boolean hasFocus) {
        super.setFocus(hasFocus);
    }

    @Override
    public void startEditing() {
        super.startEditing();
        this.textField.getCaret().setVisible(true);
    }

    @Override
    public void stopEditing() {
        this.textField.getCaret().setVisible(false);
        super.stopEditing();
    }

    @Override
    protected String getValidationErrorMessage() {
        Object value;
        String text = this.textField.getText();
        if (text.length() != 0) {
            try {
                value = this.converter.convertFromView(text);
            }
            catch (ParseException e) {
                return e.getLocalizedMessage();
            }
        } else {
            value = null;
        }
        for (Validator validator : this.validators) {
            String validationErrorMessage = validator.getValidationErrorMessage(value);
            if (validationErrorMessage == null) continue;
            this.textField.setToolTipText(validationErrorMessage);
            return validationErrorMessage;
        }
        return null;
    }

    @Override
    protected void keepValue(Object value) {
        String textValue = this.converter.convertToView(value);
        this.textField.setText(textValue);
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextFieldCellView.this.fireValueWasChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextFieldCellView.this.fireValueWasChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextFieldCellView.this.fireValueWasChanged();
            }
        };
    }

    private void setConverter(Converter converter) {
        if (converter == null) {
            converter = new Converter(){

                @Override
                public Object convertFromView(String value) {
                    return value;
                }

                @Override
                public String convertToView(Object value) {
                    return (String)value;
                }
            };
        }
        this.converter = converter;
    }

    private void setValidators(Validator ... validators) {
        this.validators = new ArrayList<Validator>();
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator validator = validatorArray[n2];
            this.validators.add(validator);
            ++n2;
        }
    }

    public static enum HorizontalAlignment {
        RIGHT(4),
        LEFT(2),
        CENTER(0);

        private int swingConstant;

        private HorizontalAlignment(int swingConstant) {
            this.swingConstant = swingConstant;
        }

        public static HorizontalAlignment getDefault() {
            return LEFT;
        }

        private int getSwingConstant() {
            return this.swingConstant;
        }
    }
}

