package csbase.client.applications.flowapplication.graph.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddNodePopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.ParametersTransferable;
import csbase.client.applications.flowapplication.messages.CheckClipboardFlavorMessage;
import csbase.client.applications.flowapplication.messages.PasteMessage;

/**
 * Ao de menu popup que colar os valores dos parmetros de um n de fluxo de
 * algoritmos.
 * 
 * @author lmoreira
 */
public final class PasteParameterValuesAction extends GraphElementAction {

  /**
   * Cria a ao.
   * 
   * @param node O n (No aceita {@code null}).
   */
  public PasteParameterValuesAction(final GraphNode node) {
    super(node, PasteParameterValuesAction.class.getName() + ".name",
      ApplicationImages.ICON_PASTE_16);
    final boolean canPaste =
      CheckClipboardFlavorMessage.canPasteFromClipboard(node,
        ParametersTransferable.DATA_FLAVOR);
    setEnabled(canPaste);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(final ActionEvent event) {
    final GraphNode node = (GraphNode) getElement();
    final PasteMessage pasteMessage = new PasteMessage();
    pasteMessage.sendVS(node);
    if (pasteMessage.getTransferable() != null) {
      pasteMessage.sendVO(node);
    }
  }

  /**
   * Cria o filtro que cadastra a ao no menu popup.
   * 
   * @param workspace A rea de trabalho (No aceita {@code null}).
   * 
   * @return O filtro.
   */
  public static WorkspaceFilter createFilter(final Workspace workspace) {
    if (workspace == null) {
      throw new IllegalArgumentException("O parmetro workspace est nulo.");
    }
    return new AddNodePopupActionFilter(workspace) {

      @Override
      protected Action createAction(final GraphNode node, final Point2D point) {
        if (!node.isWellFormed()) {
          return null;
        }
        return new PasteParameterValuesAction(node);
      }
    };
  }
}
