package csbase.client.applications.projectsmanager.panels.renderers;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;

/**
 * Renderer de alocao de espao de projeto.
 * 
 * @author jnlopes
 * 
 */
public class TableSpaceAllocationRenderer extends DefaultTableCellRenderer {

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    final Component component =
      super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
        row, column);
    final JLabel label = (JLabel) component;

    if (value != null) {

      if (value instanceof ProjectSpaceAllocation) {
        final ProjectSpaceAllocation allocation =
          (ProjectSpaceAllocation) value;
        label.setHorizontalAlignment(SwingConstants.CENTER);
        label.setIcon(allocation.getIcon());
        label.setText(null);
        label.setToolTipText(allocation.getDescription());
      }
      else {
        /*
         * Esta exceo  lanada caso o renderer receba um objeto que no seja
         * uma instncia da classe esperada.
         */
        throw new RuntimeException();
      }
    }

    return label;
  }

}
