package csbase.client.preferences.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;

/**
 * Anotao que define que uma preferncia do usurio ser oculta. Preferncias
 * anotadas com {@link Hidden} no so visveis nas aplicaes que exibem as
 * preferncias.
 * 
 * Nota: Ao anotarmos uma preferncia com esta anotao, o valor de preferncia,
 * {@link PreferenceValue},  criado com a poltica de visibilidade equivalente.
 * 
 * Os editores de preferncias que so subclasses de {@link PreferenceEditor}
 * precisam explicitamente habilitar/desabilitar seus editores de acordo com o
 * valor definido pelo mtodo {@link PreferenceValue#getPolicy()}.
 * 
 * @see PreferenceDefinition
 * 
 * @author Tecgraf
 */
@Documented
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Hidden {

}
