/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ParameterGroupView;
import csbase.client.algorithms.parameters.ParameterLoaderCommandExecutionTask;
import csbase.client.algorithms.parameters.ParameterLoaderTask;
import csbase.client.algorithms.tasks.ViewValidationTask;
import csbase.client.algorithms.validation.ValidationTranslator;
import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.validation.ViewValidator;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.ParseException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.parameters.ParameterLoader;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.SimpleAlgorithmParser;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import tecgraf.javautils.core.lng.LNG;

public class ParameterLoaderView
implements ViewValidator {
    private JButton button;
    private ParameterLoader parameterLoader;
    private ParameterGroupView groupView;
    private String outputExtractFileName;
    private Map<String, String> extractParametersValues;

    public ParameterLoaderView(ParameterGroupView groupView, ParameterLoader parameterLoader) {
        this.parameterLoader = parameterLoader;
        this.groupView = groupView;
        this.extractParametersValues = new HashMap<String, String>();
        this.button = new JButton(LNG.get((String)"ParameterLoaderView.button"));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ParameterLoaderView.this.loadParameterValues();
                if (ParameterLoaderView.this.groupIsValid(ValidationMode.ALLOW_EMPY_VALUES, true)) {
                    ParameterLoaderView.this.submitExtractCommand();
                }
            }
        });
    }

    @Override
    public ViewValidationResult validate(ValidationMode mode) {
        if (this.getComponent().isEnabled()) {
            boolean isValid = true;
            if (this.parameterLoader.isInputValidationEnabled()) {
                Map allParametersValues = this.getConfigurator().getParameterValuesByName();
                for (String parameterName : this.extractParametersValues.keySet()) {
                    if (!this.parameterLoader.getInputParameterNames().contains(parameterName)) continue;
                    String parameterValue = (String)allParametersValues.get(parameterName);
                    String extractorValue = this.extractParametersValues.get(parameterName);
                    if (extractorValue != null && extractorValue.equals(parameterValue)) continue;
                    isValid = false;
                    break;
                }
            }
            if (isValid) {
                return new ViewValidationResult(this);
            }
        }
        LocalizedMessage message = new LocalizedMessage(ParameterLoaderView.class, "error.validationError");
        ViewValidationResult result = new ViewValidationResult(message, (ViewValidator)this);
        return result;
    }

    @Override
    public boolean highlightValidationResult(ViewValidationResult result) {
        if (!result.isWellSucceded()) {
            Toolkit.getDefaultToolkit().beep();
            String message = ValidationTranslator.translateMessage((Validation)result);
            StandardErrorDialogs.showErrorDialog(this.groupView.getWindow(), LNG.get((String)"ParameterLoaderView.error.title"), message);
            this.getComponent().requestFocus();
        }
        return true;
    }

    private void loadParameterValues() {
        this.clearParameterValues();
        Map allParametersValues = this.getConfigurator().getParameterValuesByName();
        Set parametersNames = this.parameterLoader.getInputParameterNames();
        for (String parameterName : parametersNames) {
            String parameterValue = (String)allParametersValues.get(parameterName);
            this.extractParametersValues.put(parameterName, parameterValue);
        }
    }

    private boolean groupIsValid(ValidationMode mode, boolean complain) {
        ViewValidationResult validation = ViewValidationTask.runTask(this.groupView.getWindow(), this.groupView, mode, complain);
        if (validation.isWellSucceded()) {
            return true;
        }
        this.clearParameterValues();
        return false;
    }

    private void submitExtractCommand() {
        Window window = this.groupView.getWindow();
        this.setEnabled(false);
        this.outputExtractFileName = "outputExtract_" + System.currentTimeMillis();
        ParameterLoaderCommandExecutionTask task = new ParameterLoaderCommandExecutionTask(window, this);
        if (task.execute(window, LNG.get((String)"ParameterLoaderView.executing.title"), LNG.get((String)"ParameterLoaderView.executing.msg"))) {
            if (((Boolean)task.getResult()).booleanValue()) {
                this.extractParameter();
            } else {
                StandardErrorDialogs.showErrorDialog(window, LNG.get((String)"ParameterLoaderView.executing.title"), String.format(LNG.get((String)"ParameterLoaderView.executing.error"), "Extrator de Par\u00e2metros"));
                this.clearParameterValues();
            }
        } else {
            this.clearParameterValues();
        }
        this.setEnabled(true);
    }

    private AlgorithmConfigurator getConfigurator() {
        return this.groupView.getConfigurator();
    }

    private void showErrorDialog(String msg, Exception e) {
        StandardErrorDialogs.showErrorDialog(this.groupView.getWindow(), LNG.get((String)"ParameterLoaderView.error.title"), msg, e);
    }

    private void clearParameterValues() {
        this.extractParametersValues.clear();
    }

    private void extractParameter() {
        SimpleAlgorithmConfigurator configurator = (SimpleAlgorithmConfigurator)this.getConfigurator();
        SimpleAlgorithmParser parser = new SimpleAlgorithmParser();
        ParameterLoaderTask task = new ParameterLoaderTask(this.groupView.getWindow(), this);
        if (!task.execute(this.groupView.getWindow(), LNG.get((String)"ParameterLoaderView.loading.title"), LNG.get((String)"ParameterLoaderView.loading.msg"))) {
            return;
        }
        String fileContents = (String)task.getResult();
        try {
            parser.loadModifications(configurator, (Reader)new StringReader(fileContents));
        }
        catch (ParseException pe) {
            this.showErrorDialog(LNG.get((String)"ParameterLoaderView.error.parseError"), (Exception)((Object)pe));
        }
    }

    private void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
    }

    public JComponent getComponent() {
        return this.button;
    }

    public Map<String, String> getExtractParametersValues() {
        return this.extractParametersValues;
    }

    public String getOutputExtractFileName() {
        return this.outputExtractFileName;
    }

    public ParameterLoader getParameterLoader() {
        return this.parameterLoader;
    }
}

