/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.jobmonitor;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.jobmonitor.JobMonitorPref;
import csbase.client.applications.jobmonitor.JobMonitorSystemInfo;
import csbase.client.applications.jobmonitor.actions.DetailsJobInfoAction;
import csbase.client.applications.jobmonitor.actions.RefreshJobInfoAction;
import csbase.client.applications.jobmonitor.drivers.JobInfoDriver;
import csbase.client.applications.jobmonitor.drivers.PBSDriver;
import csbase.client.applications.jobmonitor.filters.FilteredTablePanel;
import csbase.client.applications.jobmonitor.filters.JobInfoFilter;
import csbase.client.applications.jobmonitor.rowmodel.JobInfoRow;
import csbase.client.desktop.RemoteTask;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import csbase.client.facilities.configurabletable.table.RowToKey;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.types.PVTables;
import csbase.client.remote.srvproxies.SGAProxy;
import csbase.exception.CSBaseException;
import csbase.logic.SGASet;
import csbase.logic.Utilities;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class JobMonitor
extends Application {
    private JPanel contentPanel = new JPanel(new GridBagLayout());
    private Map<String, JobInfoDriver> drivers = new HashMap<String, JobInfoDriver>();
    private Map<String, ConfigurableTable<JobInfoRow>> tables = new HashMap<String, ConfigurableTable<JobInfoRow>>();
    private String PBS_DRIVER = "PBS_DRIVER";
    private AbstractAction refresh = new RefreshJobInfoAction(this);
    private AbstractAction details = new DetailsJobInfoAction(this);
    private AbstractAction exit = new ApplicationExitAction(this);
    private Thread updateDataThread;

    public JobMonitor(String id) throws ApplicationException {
        super(id);
        this.setConsoleInfo(this.getString("console.wait.jobs.info"));
        this.loadDrivers();
        this.buildInterface();
        this.updateDataThread = new UpdateDataThread(this);
        this.updateDataThread.start();
    }

    public void updateContent() {
        try {
            List<SGASet> allSGASet = this.getSGASetList();
            HashMap sgaByDriver = new HashMap();
            sgaByDriver.put(this.PBS_DRIVER, new ArrayList());
            for (SGASet sGASet : allSGASet) {
                if (!sGASet.isCluster()) continue;
                ((List)sgaByDriver.get(this.PBS_DRIVER)).add(sGASet);
            }
            for (Map.Entry entry : sgaByDriver.entrySet()) {
                String driverId = (String)entry.getKey();
                List sgaSetList = (List)entry.getValue();
                this.updateView(driverId, sgaSetList);
            }
            String timeText = Utilities.getFormattedDate((long)new Date().getTime());
            this.setConsoleInfo(this.getString("console.last.update") + timeText);
        }
        catch (CSBaseException e) {
            this.setConsoleError(this.getString("console.connecting.error"));
        }
    }

    public JobInfoRow getSelectedObject() {
        for (ConfigurableTable<JobInfoRow> table : this.tables.values()) {
            if (table.getSelectedRowCount() <= 0) continue;
            return table.getSelectedObjects().get(0);
        }
        return null;
    }

    public JobMonitorSystemInfo getSystemInfo() {
        Icon systemIcon = this.getSystemIcon();
        String systemName = this.getStringSpecificProperty("system.name");
        return new JobMonitorSystemInfo(systemIcon, systemName);
    }

    @Override
    public void killApplication() throws ApplicationException {
        PreferenceCategory pc = this.getPreferences();
        PVTables pv = (PVTables)pc.getPreference(JobMonitorPref.PBS_TABLES);
        pv.storeTables(new ArrayList(this.tables.values()));
        this.savePreferences();
        if (!this.updateDataThread.isInterrupted()) {
            this.updateDataThread.interrupt();
        }
    }

    @Override
    protected boolean userCanKillApplication() {
        return true;
    }

    private void loadDrivers() {
        this.drivers.put(this.PBS_DRIVER, new PBSDriver(this));
    }

    private void buildInterface() {
        ApplicationFrame appFrame = this.getApplicationFrame();
        appFrame.setLayout(new GridBagLayout());
        appFrame.setJMenuBar(this.createMenuBar());
        appFrame.add((Component)this.createToolBar(), new GBC(0, 0).horizontal());
        appFrame.add((Component)this.contentPanel, new GBC(0, 1).both().top(10));
        appFrame.setPreferredSize(new Dimension(700, 400));
        appFrame.pack();
    }

    private void updateView(String driverId, List<SGASet> sgas) {
        JobInfoDriver driver = this.drivers.get(driverId);
        if (this.tables.containsKey(driverId)) {
            ConfigurableTable<JobInfoRow> table = this.tables.get(driverId);
            List<JobInfoRow> newRows = driver.getRows(sgas);
            table.updateRows(newRows);
        } else {
            ConfigurableTable<JobInfoRow> table = driver.getTable(sgas);
            if (table != null) {
                this.addTableListeners(table);
                table.setFilter(new JobInfoFilter());
                table.setRowToKey(new RowToKey<JobInfoRow>(){

                    @Override
                    public String getKey(JobInfoRow row) {
                        String value = row.get("Job_Id");
                        return value;
                    }
                });
                PreferenceCategory pc = this.getPreferences();
                PVTables pv = (PVTables)pc.getPreference(JobMonitorPref.PBS_TABLES);
                pv.loadTable(table);
                this.contentPanel.add((Component)new FilteredTablePanel(this, table), new GBC(0, this.tables.size()).both().insets(10));
                this.tables.put(driverId, table);
                this.contentPanel.repaint();
            }
        }
    }

    private JMenuBar createMenuBar() {
        JMenu servers = new JMenu(this.getString("menu.servers"));
        servers.add(this.details);
        servers.add(this.refresh);
        servers.add(this.exit);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(servers);
        return menuBar;
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.details);
        toolBar.add(this.refresh);
        return toolBar;
    }

    private void addTableListeners(final ConfigurableTable<JobInfoRow> table) {
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JobMonitor.this.details.setEnabled(table.getSelectedRowCount() == 1);
            }
        });
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && JobMonitor.this.details.isEnabled()) {
                    JobMonitor.this.details.actionPerformed(null);
                }
            }
        });
    }

    private List<SGASet> getSGASetList() throws CSBaseException {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        RemoteTask<List<SGASet>> task = new RemoteTask<List<SGASet>>(){

            protected void performTask() {
                try {
                    ArrayList<SGASet> result = new ArrayList<SGASet>();
                    for (String sgaName : sgaService.getAllSGANames()) {
                        SGASet sgaSet = sgaService.getSGASet(sgaName);
                        if (!sgaSet.getAlive()) continue;
                        result.add(sgaSet);
                    }
                    this.setResult(result);
                }
                catch (RemoteException e) {
                    this.setResult(null);
                }
            }
        };
        task.execute(this.getApplicationFrame(), this.getName(), this.getString("task.message.sga.list"));
        List result = (List)task.getResult();
        if (result == null) {
            throw new CSBaseException("N\u00e3o foi poss\u00edvel obter as informa\u00e7\u00f5es dos SGAs.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getSystemIcon() {
        String systemIconPath = this.getStringSpecificProperty("system.icon");
        String[] resourcePath = systemIconPath.split("/");
        InputStream input = this.getResource(resourcePath);
        ImageIcon icon = null;
        if (input != null) {
            try {
                BufferedImage image = ImageIO.read(input);
                icon = new ImageIcon(image);
            }
            catch (IOException e) {
            }
            finally {
                FileUtils.close((Closeable)input);
            }
        }
        return icon;
    }

    private void setConsoleInfo(String msg) {
        this.getApplicationFrame().getStatusBar().setInfo(msg);
    }

    private void setConsoleError(String msg) {
        this.getApplicationFrame().getStatusBar().setError(msg);
    }

    private class UpdateDataThread
    extends Thread {
        private boolean hasToUpdate;
        private JobMonitor app;

        public UpdateDataThread(JobMonitor app) {
            super("UpdateDataThread");
            this.app = app;
            this.hasToUpdate = true;
        }

        @Override
        public void run() {
            int updateIntervalAsInt = SGAProxy.getUpdateInterval();
            if (updateIntervalAsInt == -1) {
                return;
            }
            long updateInterval = (long)updateIntervalAsInt * 1000L;
            while (this.hasToUpdate) {
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JobMonitor.this.updateContent();
                        UpdateDataThread.this.app.setChanged();
                        UpdateDataThread.this.app.notifyObservers();
                    }
                });
                this.waitUpdateInterval(updateInterval);
            }
        }

        private void waitUpdateInterval(long updateInterval) {
            try {
                Thread.sleep(updateInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interrupt() {
            UpdateDataThread updateDataThread = this;
            synchronized (updateDataThread) {
                this.hasToUpdate = false;
            }
            super.interrupt();
        }
    }
}

