/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.pdfviewer;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationAboutAction;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.pdfviewer.actions.OpenLocalPdfFileAction;
import csbase.client.applications.pdfviewer.actions.OpenProjectPdfFileAction;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.project.ProjectTreeListener;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.core.PDFDocument;
import tecgraf.javautils.pdfviewer.core.PDFReader;
import tecgraf.javautils.pdfviewer.core.listeners.PDFDocumentOpenCloseListener;
import tecgraf.javautils.pdfviewer.core.listeners.PDFZoomFitPolicyChangedListener;
import tecgraf.javautils.pdfviewer.viewer.PDFViewerPanel;
import tecgraf.javautils.pdfviewer.viewer.listeners.PDFThumbnailsVisibilityListener;

public class PDFViewer
extends Application {
    private final PDFViewerPanel pdfViewerPanel;
    private final Action openLocalFileAction = new OpenLocalPdfFileAction(this);
    private final Action openProjFileAction = new OpenProjectPdfFileAction(this);
    private final ProjectTreeListener openProjFileEnabler = new ProjectTreeAdapter(){

        @Override
        public void projectChanged(CommonClientProject project) {
            PDFViewer.this.openProjFileAction.setEnabled(project != null);
        }
    };

    public PDFViewer(String id) {
        super(id);
        this.getApplicationFrame().setPreferredSize(new Dimension(800, 600));
        this.getApplicationFrame().setLayout(new BorderLayout());
        this.pdfViewerPanel = new PDFViewerPanel(this.getLocale());
        this.getApplicationFrame().add((Component)this.pdfViewerPanel, "Center");
        this.setupToolBar();
        this.setupMenuBar();
        this.addListeners();
        this.getApplicationFrame().pack();
    }

    private void addListeners() {
        this.addOpenProjFileEnablerListener();
        this.pdfViewerPanel.addPDFDocumentOpenCloseListener(new PDFDocumentOpenCloseListener(){

            public void documentOpened(PDFCorePanel pdfViewerPanel) {
            }

            public void documentClosed(PDFCorePanel source) {
                PDFViewer.this.setTitleFilename(null);
            }
        });
    }

    private void setupMenuBar() {
        JMenu fileMenu = new JMenu(this.getString("file.menu"));
        JMenuItem openProjFileMenuItem = new JMenuItem(this.openProjFileAction);
        fileMenu.add(openProjFileMenuItem);
        if (this.canOpenLocalFiles()) {
            JMenuItem openLocalFileMenuItem = new JMenuItem(this.openLocalFileAction);
            fileMenu.add(openLocalFileMenuItem);
        }
        fileMenu.addSeparator();
        fileMenu.add(this.pdfViewerPanel.getPDFCloseAction());
        fileMenu.addSeparator();
        fileMenu.add(new ApplicationExitAction(this));
        JMenu viewMenu = new JMenu(this.getString("view.menu"));
        viewMenu.add(this.pdfViewerPanel.getPrevPageAction());
        viewMenu.add(this.pdfViewerPanel.getNextPageAction());
        viewMenu.addSeparator();
        viewMenu.add(this.pdfViewerPanel.getZoomInAction());
        viewMenu.add(this.pdfViewerPanel.getZoomOutAction());
        final ButtonGroup fitButtonGroup = new ButtonGroup();
        final JCheckBoxMenuItem fitWholePageMenuItem = new JCheckBoxMenuItem(this.pdfViewerPanel.getFitWholePageAction());
        fitButtonGroup.add(fitWholePageMenuItem);
        viewMenu.add(fitWholePageMenuItem);
        final JCheckBoxMenuItem fitWidthMenuItem = new JCheckBoxMenuItem(this.pdfViewerPanel.getFitWidthAction());
        fitButtonGroup.add(fitWidthMenuItem);
        viewMenu.add(fitWidthMenuItem);
        final JCheckBoxMenuItem fitHeightMenuItem = new JCheckBoxMenuItem(this.pdfViewerPanel.getFitHeightAction());
        fitButtonGroup.add(fitHeightMenuItem);
        viewMenu.add(fitHeightMenuItem);
        this.pdfViewerPanel.addPDFZoomFitPolicyChangedListener(new PDFZoomFitPolicyChangedListener(){

            public void zoomFitPolicyChanged(PDFCorePanel.ZoomFitPolicy policy) {
                if (policy == PDFCorePanel.ZoomFitPolicy.FREE) {
                    fitButtonGroup.clearSelection();
                } else if (policy == PDFCorePanel.ZoomFitPolicy.WIDTH) {
                    fitWidthMenuItem.setSelected(true);
                } else if (policy == PDFCorePanel.ZoomFitPolicy.HEIGHT) {
                    fitHeightMenuItem.setSelected(true);
                } else if (policy == PDFCorePanel.ZoomFitPolicy.WHOLE_PAGE) {
                    fitWholePageMenuItem.setSelected(true);
                }
            }
        });
        viewMenu.addSeparator();
        final JCheckBoxMenuItem showThumbnailsMenuItem = new JCheckBoxMenuItem(this.pdfViewerPanel.getPDFShowThumbnailsAction());
        this.pdfViewerPanel.addPDFThumbnailsVisibilityListeners(new PDFThumbnailsVisibilityListener(){

            public void onThumbnailsVisibilityChanged(boolean visible) {
                showThumbnailsMenuItem.setSelected(visible);
            }
        });
        viewMenu.add(showThumbnailsMenuItem);
        JMenu helpMenu = new JMenu(this.getString("help.menu"));
        helpMenu.add(new ApplicationAboutAction(this));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        menuBar.add(helpMenu);
        this.getApplicationFrame().setJMenuBar(menuBar);
    }

    private void addOpenProjFileEnablerListener() {
        ProjectTree projectTree = DesktopFrame.getInstance().getTree();
        projectTree.addProjectTreeListener(this.openProjFileEnabler);
        this.openProjFileAction.setEnabled(projectTree.getProject() != null);
    }

    private void removeOpenProfFileEnablerListener() {
        ProjectTree projectTree = DesktopFrame.getInstance().getTree();
        projectTree.removeProjectTreeListener(this.openProjFileEnabler);
    }

    private void setupToolBar() {
        JToolBar appToolBar = new JToolBar();
        appToolBar.setFloatable(false);
        appToolBar.add(this.openProjFileAction);
        if (this.canOpenLocalFiles()) {
            appToolBar.add(this.openLocalFileAction);
        }
        appToolBar.addSeparator();
        appToolBar.add(this.pdfViewerPanel.getPDFToolBar());
        this.getApplicationFrame().add((Component)appToolBar, "North");
    }

    boolean canOpenLocalFiles() {
        return !this.getApplicationRegistry().requireProject();
    }

    @Override
    public void killApplication() throws ApplicationException {
        this.pdfViewerPanel.closePDF();
        this.removeOpenProfFileEnablerListener();
    }

    @Override
    protected boolean userCanKillApplication() {
        return true;
    }

    public void openPdfFile(final ClientFile clientFile) {
        RemoteTask<PDFDocument> loadPdfDocumentTask = new RemoteTask<PDFDocument>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void performTask() throws Exception {
                try {
                    InputStream inputStream = clientFile.getInputStream();
                    PDFDocument document = new PDFReader().read(inputStream);
                    this.setResult(document);
                }
                catch (IOException ex) {
                    SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            StandardDialogs.showErrorDialog((Component)PDFViewer.this.buildApplicationFrame(), (String)PDFViewer.this.getString("pdfviewer.open.error.title"), (String)(PDFViewer.this.getString("pdfviewer.open.error") + ex.getMessage()));
                        }
                    });
                }
                finally {
                    clientFile.close(true);
                }
            }
        };
        String taskTitle = this.getName();
        String taskDescription = this.getString("loading.file.message");
        loadPdfDocumentTask.execute(this.getApplicationFrame(), taskTitle, taskDescription);
        if (loadPdfDocumentTask.getStatus()) {
            this.pdfViewerPanel.loadDocument((PDFDocument)loadPdfDocumentTask.getResult());
            this.setTitleFilename(clientFile.getName());
        }
    }

    public void closePdfFile() {
        this.pdfViewerPanel.closePDF();
    }

    @Override
    public void sendMessage(String name, Object value, String senderId) {
        if (value == null) {
            return;
        }
        if (name.equals("PROJECT_FILE")) {
            ClientProjectFile clientFile = (ClientProjectFile)value;
            this.openPdfFile((ClientFile)clientFile);
        }
    }

    private void setTitleFilename(String filename) {
        String windowTitle = this.getName();
        if (filename != null) {
            windowTitle = windowTitle + " - " + filename;
        }
        this.getApplicationFrame().setTitle(windowTitle);
    }
}

