/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.dialogs;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.dialogs.core.ProjectsManagerDialog;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.ProjectSharingInfoPanel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

public class ProjectStatusModificationDialog
extends ProjectsManagerDialog {
    private final JTextField allocatedSpaceField = new JTextField();
    private final Insets insets = new Insets(5, 5, 5, 5);
    private List<ProjectsManagerData> projectList;
    private int allocatedSpace = -1;

    private ProjectStatusModificationDialog(ProjectsManager projectsManager, List<ProjectsManagerData> projectList) {
        super(projectsManager);
        this.projectList = projectList;
        this.setModal(true);
        this.setTitle(this.getString("ProjectStatusModificationDialog.title"));
        this.buildPanel();
    }

    private JPanel buildButtonsPanel() {
        JButton modifyButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectsManager projectsManager = ProjectStatusModificationDialog.this.getProjectsManager();
                ApplicationFrame appFrame = projectsManager.getApplicationFrame();
                try {
                    ProjectStatusModificationDialog.this.allocatedSpace = Integer.parseInt(ProjectStatusModificationDialog.this.allocatedSpaceField.getText());
                }
                catch (NumberFormatException nfe) {
                    ProjectStatusModificationDialog.this.allocatedSpace = -1;
                }
                if (ProjectStatusModificationDialog.this.allocatedSpace <= 0) {
                    StandardDialogs.showErrorDialog((Component)appFrame, (String)ProjectStatusModificationDialog.this.getString("ProjectStatusModificationDialog.number.error.message"), (String)ProjectStatusModificationDialog.this.getString("ProjectStatusModificationDialog.number.error.title"));
                    return;
                }
                ProjectStatusModificationDialog.this.dispose();
            }
        });
        modifyButton.setText(this.getString("ProjectStatusModificationDialog.modify.text"));
        JButton cancelButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectStatusModificationDialog.this.dispose();
            }
        });
        cancelButton.setText(this.getString("ProjectStatusModificationDialog.cancel.text"));
        JComponent[] buttons = new JComponent[]{modifyButton, cancelButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(modifyButton);
        buttonsPanel.add(cancelButton);
        return buttonsPanel;
    }

    private JPanel buildTextPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.getString("ProjectStatusModificationDialog.allocated.space.label")), new GBC(0, 0).insets(this.insets));
        panel.add((Component)this.allocatedSpaceField, new GBC(1, 0).horizontal().insets(this.insets));
        panel.add((Component)new JLabel("gb"), new GBC(2, 0).insets(this.insets));
        return panel;
    }

    private ProjectSharingInfoPanel buildProjectPanel() {
        ProjectsManager projectsManager = this.getProjectsManager();
        ProjectSharingInfoPanel projectsPanel = new ProjectSharingInfoPanel(projectsManager, this.projectList, false);
        return projectsPanel;
    }

    private void buildPanel() {
        JPanel buttonsPanel = this.buildButtonsPanel();
        ProjectSharingInfoPanel projectsPanel = this.buildProjectPanel();
        JLabel label = new JLabel(this.getString("ProjectStatusModificationDialog.warning.label"), ApplicationImages.ICON_WARNING_32, 2);
        this.setLayout(new GridBagLayout());
        this.add((Component)label, new GBC(0, 0).insets(this.insets));
        this.add((Component)projectsPanel, new GBC(0, 1).horizontal().insets(this.insets));
        this.add((Component)this.buildTextPanel(), new GBC(0, 2).both().insets(this.insets));
        this.add((Component)buttonsPanel, new GBC(0, 3).horizontal().insets(this.insets));
    }

    public static int openDialog(ProjectsManager projectsManager, List<ProjectsManagerData> projectList) {
        ProjectStatusModificationDialog psmd = new ProjectStatusModificationDialog(projectsManager, projectList);
        psmd.pack();
        psmd.setVisible(true);
        return psmd.allocatedSpace;
    }
}

