package csbase.client.algorithms.parameters;

import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JComponent;
import javax.swing.JTextField;

import csbase.logic.algorithms.parameters.FormulaParameter;

/**
 * A viso para o parmetro do tipo Frmula.
 * 
 * @author lmoreira
 */
public final class FormulaParameterView extends SimpleParameterView<String> {

  /**
   * Cria a viso em modo {@link ParameterView.Mode#CONFIGURATION}.
   * 
   * @param window NO EST SENDO UTILIZADO. Existe somente para manter
   *        compatibilidade com o WebSintesi.
   * @param formulaParameter O parmetro (No aceita {@code null}).
   * 
   * @deprecated para manter compatibilidade com o WebSintesi
   */
  @Deprecated
  public FormulaParameterView(Window window, FormulaParameter formulaParameter) {
    this(formulaParameter, Mode.CONFIGURATION);
  }

  /**
   * Cria a viso.
   * 
   * @param formulaParameter O parmetro (No aceita {@code null}).
   * @param mode Modo de visualizao. No aceita {@code null}, os possveis
   *        valores so: {@link ParameterView.Mode#CONFIGURATION} ou
   *        {@link ParameterView.Mode#REPORT}.
   */
  public FormulaParameterView(FormulaParameter formulaParameter, Mode mode) {
    super(formulaParameter, mode);

    updateCapabilityView();
    updateVisibilyView();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public FormulaParameter getParameter() {
    return (FormulaParameter) super.getParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createConfigurationComponent(Object... componentArgs) {
    return new FormulaConfigurationParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createReportComponent(Object... componentArgs) {
    return new FormulaReportParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void updateViewContents() {
    ((IFormulaParameterComponent) getComponent()).updateViewContents();
  }

  /**
   * Interface comum s diferentes vises do parmetro.
   */
  private interface IFormulaParameterComponent {
    /**
     * Atualiza o contedo exibido pela viso.
     */
    void updateViewContents();
  }

  /**
   * Viso do parmetro em modo {@link ParameterView.Mode#REPORT}.
   */
  private final class FormulaReportParameter extends JTextField implements
    IFormulaParameterComponent {

    /**
     * Construtor.
     */
    FormulaReportParameter() {
      setToolTipText(getParameter().getDescription());
      ComponentProperties.setProperties(this, Mode.REPORT, true);
      super.setEditable(false);
      updateViewContents();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void updateViewContents() {
      String value = getParameter().getValue();
      setText(null == value ? " " : value);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void setEditable(boolean enable) {
      //Este mtodo no faz nada por que este componente no pode ser editvel.
    }
  }

  /**
   * Viso do parmetro em modo {@link ParameterView.Mode#CONFIGURATION}.
   */
  private final class FormulaConfigurationParameter extends JTextField
    implements IFormulaParameterComponent {

    /**
     * Construtor.
     */
    FormulaConfigurationParameter() {
      addFocusListener(new FocusListener() {
        @Override
        public void focusGained(FocusEvent e) {
          //Ignora o evento.
        }

        @Override
        public void focusLost(FocusEvent e) {
          updateModel();
        }
      });

      setToolTipText(getParameter().getDescription());
      updateViewContents();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void updateViewContents() {
      String value = getParameter().getValue();
      setText(null == value ? "" : value);
    }

    /**
     * Atualiza o modelo (L informaes da viso e atrubui a informao ao
     * parmetro).
     */
    private void updateModel() {
      String text = getText();
      if (text.length() == 0) {
        getParameter().setValue(null);
      }
      else {
        getParameter().setValue(text);
      }
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean fillVerticalSpace() {
    return false;
  }
}
