/*
 * $Id: RequestInterruptAction.java 126768 2012-02-29 17:52:25Z clinio $
 */
package csbase.client.applications.filetransferclient.actions;

import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.queuepanel.FileTransferClientQueuePanel;

/**
 * @author Tecgraf/PUC-Rio
 */
public final class RequestInterruptAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) {
    final FileTransferClient application = getApplication();
    final FileTransferClientQueuePanel queuePanel = application.getQueuePanel();
    final List<String> ids = queuePanel.getSelectedRequestsIds();
    final FileTransferProxy proxy = application.getServiceProxy();
    proxy.interruptRequests(ids);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Construtor.
   * 
   * @param application aplicaco.
   */
  public RequestInterruptAction(final FileTransferClient application) {
    super(application);
  }
}
