package csbase.client.applications.projectsmanager.actions;

import java.util.List;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.SearchFilesDialog;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;

/**
 * Ao que abre dilogo para pesquisa de arquivos nos projetos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class SearchFilesDialogAction extends ProjectsManagerAction {

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public SearchFilesDialogAction(final ProjectsManager projectsManager) {
    super(projectsManager);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() {
    final ProjectsManager projectsManager = getProjectsManager();

    /*
     * lista de projetos FILTRADOS, se nenhum filtro estiver sendo utilizado
     * esta lista  igual a lista de TODOS os projetos que o usurio tem acesso
     */
    final List<ProjectsManagerData> projects =
      projectsManager.getVisibleProjects();

    if (projects == null || projects.size() == 0) {
      return;
    }

    // lista de projetos selecionados pelo usurio
    final List<ProjectsManagerData> selectedProjectList =
      projectsManager.getSelectedProjects();

    /*
     * Se nenhum projeto est selecionado, o default  fazer a busca de arquivos
     * em toda a lista dos projetos filtrados pelo usurio.
     */
    final boolean useAllProjectsList =
      (selectedProjectList == null || selectedProjectList.size() == 0);

    final SearchFilesDialog dialog =
      new SearchFilesDialog(projectsManager, selectedProjectList, projects,
        useAllProjectsList);
    dialog.pack();
//    dialog.center();
    dialog.setVisible(true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return ApplicationImages.ICON_FIND_16;
  }
}
