/*
 * $Id:$
 */
package csbase.client.applications.xmlviewer.styles;

import java.util.List;

import javax.swing.ImageIcon;

import org.w3c.dom.Node;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.xmlviewer.XMLViewer;
import csbase.client.util.xmlpanel.XMLPanelStyleInterface;

/**
 * Estilo padro do WebSintesi
 * 
 * @author Tecgraf/PUC-Rio
 */
public abstract class XMLPanelStyle implements XMLPanelStyleInterface {

  /**
   * {@inheritDoc}
   */
  @Override
  final public String getName() {
    final String prefix = this.getClass().getSimpleName();
    final String appPrefix = XMLViewer.class.getSimpleName();
    final String name = LNG.get(appPrefix + "." + prefix + ".style.name");
    return name;
  }

  /**
   * @param textValue texto do n.
   * @param index ndice
   * @return texto
   */
  protected String getStandardTreeText(final String textValue, final int index) {
    final String indexText = index > 0 ? index + "." : "";
    return indexText + textValue;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isTextPanelNeeded() {
    return true;
  }

  /**
   * Construtor
   */
  public XMLPanelStyle() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  abstract public List<String> getTipicalFileTypes();

  /**
   * {@inheritDoc}
   */
  @Override
  abstract public ImageIcon getIcon(final Node node, final String textValue,
    final int index);

}
