package csbase.client.util.filechooser.filters;

import javax.swing.ImageIcon;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.ApplicationImages;
import csbase.logic.ClientFile;
import csbase.logic.ProjectFileType;

/**
 * Filtro que no faz nada, servindo apenas como conceito de filtro-nulo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ClientFileAllFilter implements ClientFileFilterInterface {

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean accept(final ClientFile file) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final String getDescription() {
    final String className = this.getClass().getSimpleName();
    final String label = LNG.get(className + ".description") + " - (*.*)";
    return label;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getImageIcon() {
    return ApplicationImages.ICON_FILE_16;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ProjectFileType inferFileType() {
    return null;
  }
}