package csbase.client.util.filechooser.filters;

import javax.swing.ImageIcon;

import csbase.logic.ClientFile;
import csbase.logic.ProjectFileType;

/**
 * Filtro de arquivos para a tabela.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface ClientFileFilterInterface {

  /**
   * Filtro do que ser exibido.
   * 
   * @param file arquivo.
   * @return indicativo.
   */
  public boolean accept(final ClientFile file);

  /**
   * Consulta o valor da descrio
   * 
   * @return a descrio.
   */
  public String getDescription();

  /**
   * onsulta uma imagem associada ao filtro.
   * 
   * @return a imagem
   */
  public ImageIcon getImageIcon();

  /**
   * Mtodo que infere o tipo do arquivo (tipicamente a ser criado em modo SAVE)
   * tratado.
   * 
   * @return o cdigo do tipo do arquivo ou {@code null}
   */
  public ProjectFileType inferFileType();
}