/*
 * Decompiled with CFR 0.152.
 */
package csbase.client;

import csbase.client.ClientUI;
import csbase.client.algorithms.parameters.DefaultParameterViewFactory;
import csbase.client.algorithms.parameters.ParameterViewFactory;
import csbase.client.csdk.v1_0.CSDKContextFactory;
import csbase.client.csdk.v1_0.DefaultCSDKContextFactory;
import csbase.client.desktop.RemoteTask;
import csbase.client.externalresources.ExternalResources;
import csbase.client.kernel.ClientException;
import csbase.client.login.AbstractLoginUI;
import csbase.client.login.InitialContext;
import csbase.client.login.LoginInterface;
import csbase.client.login.LoginUI;
import csbase.client.login.PreLogin;
import csbase.client.login.UserPasswordLogin;
import csbase.client.openbus.OpenBusAccessPoint;
import csbase.client.openbus.OpenBusLogin;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.CSBaseException;
import csbase.exception.ConfigurationException;
import csbase.logic.ManifestVersion;
import csbase.logic.ServerManager;
import csbase.logic.ServerURI;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ServerEntryPoint;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.configurationmanager.MissingPropertyException;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class Client {
    private static final String DEFAULT_HOST_ADDRESS = "127.0.0.1";
    private static final String REMOTE_LOCATOR_CLASS_PROPERTY = "remote.locator.class";
    private static final String REMOTE_MONITOR_CLASS_PROPERTY = "remote.monitor.class";
    private static final String BASIC_LANGUAGE_FILE_PROPERTY = "basic.language.file";
    private static final String ADDITIONAL_LANGUAGE_FILE_PROPERTY = "additional.language.file";
    private static final String EXTERNAL_LANGUAGE_FILE_BASENAME_PROPERTY = "external.language.file.basename";
    private static final String SWING_LANGUAGE_FILE_PROPERTY = "swing.language.file";
    protected static final String DEFAULT_LOCALE_PROPERTY = "default.locale";
    private static final String EXECUTION_PERMISSION_PROPERTY = "execution.permission";
    private static final String LOGIN_CLASS_PROPERTY = "login.class";
    private static final String UI_CLASS_PROPERTY = "ui.class";
    private static final String INITIAL_CONTEXT_CLASS_PROPERTY = "initial.context.class";
    private static final String SHOW_SERVER_PROPERTY = "show.server.name";
    private Configuration configuration;
    private static Client instance;
    private LoginInterface loginObject;
    private ParameterViewFactory parameterViewFactory;
    private final CSDKContextFactory csdkContextFactory;
    private String systemName;
    private String serverName;
    private String ipStr;
    private Map<String, String> parameterMap;
    private Map<String, String> keyNotFoundInAnyIdiom;
    private Map<String, String> keyNotFoundInSelectedIdiom;
    private boolean showServerName;
    private ClientUI clientUI;
    private int sonCounter = 1;
    private Charset systemDefaultCharset;
    private Charset clientHostCharset;
    private ManifestVersion clientVersion;

    public final Charset getSystemDefaultCharset() {
        return this.systemDefaultCharset;
    }

    public final Charset getClientHostCharset() {
        return this.clientHostCharset;
    }

    public final String getSystemDefaultCharsetName() {
        Charset ch = this.getSystemDefaultCharset();
        return ch.name();
    }

    public final String getClientHostCharsetName() {
        Charset ch = this.getClientHostCharset();
        if (ch == null) {
            return null;
        }
        return ch.name();
    }

    protected Client(String systemName, Map<String, String> parameterMap) {
        if (instance != null) {
            throw new IllegalStateException("J\u00e1 existe um cliente criado.");
        }
        SwingThreadDispatcher.init();
        this.systemName = systemName;
        this.parameterMap = parameterMap;
        this.keyNotFoundInAnyIdiom = new HashMap<String, String>();
        this.keyNotFoundInSelectedIdiom = new HashMap<String, String>();
        this.clientVersion = new ManifestVersion(this.getClass());
        String server = this.parameterMap.get("server_url");
        ServerURI uri = ServerURI.parse((String)server);
        this.serverName = uri.getHost();
        try {
            this.configuration = ConfigurationManager.getInstance().getConfiguration(this.getClass());
        }
        catch (ConfigurationManagerException e) {
            throw new ConfigurationException((Throwable)e);
        }
        this.showServerName = this.configuration.getOptionalBooleanProperty(SHOW_SERVER_PROPERTY, false);
        this.parameterViewFactory = new DefaultParameterViewFactory();
        this.csdkContextFactory = this.createCSDKContextFactory();
        instance = this;
    }

    protected CSDKContextFactory createCSDKContextFactory() {
        return new DefaultCSDKContextFactory();
    }

    public String getSystemName() {
        return this.systemName;
    }

    public boolean showServerName() {
        return this.showServerName;
    }

    public boolean execute() {
        LNG.setNativeLocale((Locale)new Locale("pt", "BR"));
        Locale initLocale = this.loadInitialLocale();
        System.out.println("Locale inicial: " + initLocale.toString());
        LNG.setTranslationListener((LNG.TranslationListener)new LNG.TranslationListener(){

            public String keyNotFound(String key, String text) {
                Client.this.keyNotFoundInAnyIdiom.put(key, text);
                return text;
            }

            public String keyNotFoundInDefaultLanguage(String key, String text) {
                Client.this.keyNotFoundInSelectedIdiom.put(key, text);
                return text;
            }
        });
        System.out.println("Porta RMI do cliente: " + this.getRMIExportPort());
        this.createClientRemoteMonitor();
        this.loginObject = this.loadLoginObject(initLocale);
        if (this.loginObject == null) {
            String errTag = "csbase.client.Client.without.login.object";
            StandardDialogs.showErrorDialog(null, (String)this.systemName, (String)LNG.get((String)"csbase.client.Client.without.login.object"));
            return false;
        }
        InitialContext initialContext = this.loginObject.login(initLocale, this.systemName);
        if (initialContext == null) {
            return false;
        }
        Locale selectedLocale = initialContext.getLocale();
        this.loadLanguageFiles(selectedLocale);
        this.loadExternalLanguageFiles(selectedLocale);
        this.clientHostCharset = this.loadHostCharset();
        this.systemDefaultCharset = this.loadDefaultCharsetFromServer();
        if (this.systemDefaultCharset == null) {
            String errTag = "csbase.client.Client.charset.failed.message";
            String err = LNG.get((String)"csbase.client.Client.charset.failed.message");
            StandardDialogs.showErrorDialog(null, (String)this.systemName, (String)err);
            return false;
        }
        String sysChName = this.getSystemDefaultCharsetName();
        if (!Charset.isSupported(sysChName)) {
            String errTag = "csbase.client.Client.charset.unsupported.message";
            String err = LNG.get((String)"csbase.client.Client.charset.unsupported.message") + "[" + sysChName + "]";
            StandardDialogs.showErrorDialog(null, (String)this.systemName, (String)err);
            return false;
        }
        System.out.println(" - Charset do servidor/sistema: " + sysChName);
        this.printOnNotRegisteredCharset(this.systemDefaultCharset);
        String localChName = this.getClientHostCharsetName();
        System.out.println(" - Charset local (cliente): " + localChName);
        this.printOnNotRegisteredCharset(this.clientHostCharset);
        if (!this.doesLoggedUserHavePermission()) {
            String errTag = "csbase.client.Client.user.without.permission.message";
            StandardDialogs.showErrorDialog(null, (String)this.systemName, (String)LNG.get((String)"csbase.client.Client.user.without.permission.message"));
            return false;
        }
        this.postInitialization(initialContext);
        boolean wasClientExecuted = this.executeClientUI(initialContext);
        return wasClientExecuted;
    }

    protected LoginInterface loadLoginObject(Locale initLocale) {
        LoginInterface lObject;
        String tokenTag = "token";
        String preLoginTokenText = this.parameterMap.get("token");
        if (preLoginTokenText != null) {
            InitialContext initContext = this.createInitialContext(initLocale);
            lObject = new PreLogin(preLoginTokenText, initContext);
        } else {
            String openBusTokenTag = "openbus_token_user";
            String openBusTokenText = this.parameterMap.get("openbus_token_user");
            lObject = openBusTokenText != null ? new OpenBusLogin(this.createInitialContext(initLocale)) : new UserPasswordLogin(this.createLoginDialog());
        }
        return lObject;
    }

    private Locale loadInitialLocale() {
        String paramLocaleText = this.parameterMap.get("locale");
        Locale paramLocale = FormatUtils.parseLocale((String)paramLocaleText);
        Locale defaultLocale = Locale.getDefault();
        Locale initLocale = paramLocale == null ? defaultLocale : paramLocale;
        return initLocale;
    }

    private Charset loadHostCharset() {
        Charset charset = Charset.defaultCharset();
        return charset;
    }

    private void printOnNotRegisteredCharset(Charset charset) {
        if (charset == null) {
            return;
        }
        boolean registered = charset.isRegistered();
        if (!registered) {
            String fmt = "Charset [%s] n\u00e3o \u00e9 registrado IANA!";
            String chName = charset.name();
            String msg = String.format("Charset [%s] n\u00e3o \u00e9 registrado IANA!", chName);
            System.out.println(msg);
        }
    }

    private Charset loadDefaultCharsetFromServer() {
        RemoteTask<String> chTask = new RemoteTask<String>(){

            protected void performTask() throws RemoteException {
                ClientRemoteMonitor monitor = ClientRemoteMonitor.getInstance();
                ServerEntryPoint server = monitor.getServer();
                String chName = server.getSystemDefaultCharsetName();
                this.setResult(chName);
            }
        };
        String msgTag = "csbase.client.Client.charset.searching.message";
        String msg = LNG.get((String)"csbase.client.Client.charset.searching.message");
        boolean chTaskExecuted = chTask.execute(null, this.systemName, msg);
        if (!chTaskExecuted || chTask.wasCancelled()) {
            return null;
        }
        String chName = (String)chTask.getResult();
        if (chName == null || !Charset.isSupported(chName)) {
            return null;
        }
        Charset charset = Charset.forName(chName);
        return charset;
    }

    public final String getClientInstanceId() {
        if (this.loginObject == null) {
            return null;
        }
        return this.loginObject.getClientInstanceId();
    }

    public final String getFatherClientInstanceId() {
        if (this.loginObject == null) {
            return null;
        }
        return this.loginObject.getFatherClientInstanceId();
    }

    protected InitialContext executeDefaultLogin(Locale defaultLocale) {
        AbstractLoginUI loginDialog = this.createLoginDialog();
        return loginDialog.execute(defaultLocale);
    }

    protected Class<ClientUI> getUIClass(String uiClassProperty) {
        try {
            Class uiClass = this.configuration.getMandatoryClassProperty(uiClassProperty);
            return uiClass;
        }
        catch (MissingPropertyException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected boolean executeClientUI(final InitialContext initialContext) {
        try {
            this.clientUI = this.createUI(this.getUIClass(UI_CLASS_PROPERTY));
        }
        catch (ClientException e) {
            e.printStackTrace();
            String tag = "csbase.client.Client.create.client.ui.error.message";
            String err = LNG.get((String)"csbase.client.Client.create.client.ui.error.message");
            StandardDialogs.showErrorDialog(null, (String)this.systemName, (String)err);
            this.loginObject.notifyException(e);
            return false;
        }
        this.loginObject.notifyPreInitialization();
        RemoteTask<Void> remoteTask = new RemoteTask<Void>(){

            @Override
            protected void handleError(Exception e) {
                if (e instanceof RemoteException) {
                    super.handleError(e);
                } else {
                    e.printStackTrace();
                    String msg = e.getMessage() == null ? LNG.get((String)"csbase.client.Client.start.client.ui.error.message") : e.getMessage();
                    StandardDialogs.showErrorDialog(null, (String)Client.this.systemName, (String)msg);
                }
                Client.this.loginObject.notifyException(e);
            }

            protected void performTask() throws RemoteException, ClientException {
                Client.this.clientUI.preInitialization(initialContext);
                Client.this.clientUI.showUI();
            }
        };
        if (this.loginObject instanceof UserPasswordLogin) {
            remoteTask.setProgressDialogEnabled(false);
        } else {
            remoteTask.setProgressDialogDelay(0);
        }
        String msgTag = "csbase.client.Client.starting.client.ui.message";
        String msg = LNG.get((String)"csbase.client.Client.starting.client.ui.message");
        String message = MessageFormat.format(msg, this.systemName);
        boolean wasTaskExecuted = remoteTask.execute(null, this.systemName, message, 0, 1);
        if (!wasTaskExecuted) {
            return false;
        }
        try {
            this.clientUI.postInitialization();
        }
        catch (Exception e) {
            String tag = "csbase.client.Client.create.client.post.error.message";
            String err = LNG.get((String)"csbase.client.Client.create.client.post.error.message");
            StandardDialogs.showErrorDialog(null, (String)this.systemName, (String)err);
            this.loginObject.notifyException(e);
            return false;
        }
        this.loginObject.notifyInitialized();
        return true;
    }

    protected boolean doesLoggedUserHavePermission() {
        Class executionPermissionClass;
        try {
            executionPermissionClass = this.configuration.getOptionalClassProperty(EXECUTION_PERMISSION_PROPERTY);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException((Throwable)e);
        }
        User loggedUser = User.getLoggedUser();
        return loggedUser.isAdmin() || executionPermissionClass == null || loggedUser.getPermission(executionPermissionClass) != null;
    }

    public void loadLanguageFiles(Locale locale) {
        List basicLanguageFileList;
        try {
            basicLanguageFileList = this.configuration.getMandatoryListProperty(BASIC_LANGUAGE_FILE_PROPERTY);
        }
        catch (MissingPropertyException e) {
            throw new ConfigurationException((Throwable)e);
        }
        List additionalLanguageFileList = this.configuration.getOptionalListProperty(ADDITIONAL_LANGUAGE_FILE_PROPERTY);
        LinkedList allLanguageFileList = new LinkedList();
        allLanguageFileList.addAll(basicLanguageFileList);
        allLanguageFileList.addAll(additionalLanguageFileList);
        for (String idiomFileBaseName : allLanguageFileList) {
            LNG.load((String)idiomFileBaseName, (Locale)locale);
        }
        JComponent.setDefaultLocale(locale);
        if (!locale.getLanguage().equals(new Locale("en", "", "").getLanguage())) {
            try {
                GUIUtils.translateSwingComponents((Locale)locale, (List)this.configuration.getMandatoryListProperty(SWING_LANGUAGE_FILE_PROPERTY));
            }
            catch (MissingPropertyException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
    }

    protected boolean loadExternalLanguageFiles(Locale locale) {
        String urlPrefix = Client.getCodeBaseStr();
        List externalLanguageFileList = this.getConfiguration().getOptionalListProperty(EXTERNAL_LANGUAGE_FILE_BASENAME_PROPERTY);
        boolean success = true;
        for (String idiomFileBaseName : externalLanguageFileList) {
            try {
                LNG.loadURL((String)urlPrefix, (String)idiomFileBaseName, (Locale)locale);
            }
            catch (IOException e) {
                String name = urlPrefix + idiomFileBaseName + "_" + locale + ".properties";
                StandardErrorDialogs.showErrorDialog(null, this.getSystemName(), "Falha na carga de bundle de idiomas externo: " + name, e);
                success = false;
            }
        }
        return success;
    }

    public static String getCodeBaseStr() {
        if (ExternalResources.getInstance().isEnabled()) {
            try {
                return ExternalResources.getInstance().getCodeBase().toExternalForm();
            }
            catch (CSBaseException e) {
                return FileUtils.prepareURL((String)"");
            }
        }
        return FileUtils.prepareURL((String)"");
    }

    protected void createClientRemoteMonitor() {
        Constructor<? extends ServerManager> constructor;
        Class<? extends ServerManager> monitorClass = this.getClientRemoteMonitorClass();
        Class[] argTypes = new Class[]{String.class, String.class, Class.class};
        try {
            constructor = monitorClass.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel obter o construtor da classe de monitora\u00e7\u00e3o do servidor.");
        }
        Object[] args = new Object[]{this.systemName, this.parameterMap.get("server_url"), this.getClientRemoteLocatorClass()};
        try {
            constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel criar o monitorador do servidor.");
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel criar o monitorador do servidor.");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel criar o monitorador do servidor.");
        }
        ClientRemoteMonitor.getInstance().setSystemName(this.systemName);
    }

    protected Class<? extends ClientRemoteLocator> getClientRemoteLocatorClass() {
        try {
            return this.configuration.getOptionalClassProperty(REMOTE_LOCATOR_CLASS_PROPERTY, ClientRemoteLocator.class);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected Class<? extends ServerManager> getClientRemoteMonitorClass() {
        try {
            return this.configuration.getOptionalClassProperty(REMOTE_MONITOR_CLASS_PROPERTY, ClientRemoteMonitor.class);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void postInitialization(InitialContext initialContext) {
    }

    protected ClientUI createUI(Class<ClientUI> uiClass) throws ClientException {
        Constructor<ClientUI> constructor;
        try {
            constructor = uiClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel obter o construtor da classe de interface do usu\u00e1rio.");
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel criar a interface do usu\u00e1rio.");
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel criar a interface do usu\u00e1rio.");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClientException) {
                throw (ClientException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel criar a interface do usu\u00e1rio.");
        }
    }

    protected AbstractLoginUI createLoginDialog() {
        Constructor constructor;
        Class loginClass;
        try {
            loginClass = this.configuration.getOptionalClassProperty(LOGIN_CLASS_PROPERTY, LoginUI.class);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException((Throwable)e);
        }
        try {
            constructor = loginClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel obter o construtor da classe de login.");
        }
        try {
            return (AbstractLoginUI)constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel criar o di\u00e1logo de login.");
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel criar o di\u00e1logo de login.");
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel criar o di\u00e1logo de login.");
        }
    }

    public static Client getInstance() {
        if (instance == null) {
            String err = "A inst\u00e2ncia do cliente ainda n\u00e3o foi criada.";
            throw new IllegalArgumentException("A inst\u00e2ncia do cliente ainda n\u00e3o foi criada.");
        }
        return instance;
    }

    public final String getParameter(String parameterName) {
        String value = this.parameterMap.get(parameterName);
        if (value == null) {
            return null;
        }
        return value.trim();
    }

    public final String getServerName() {
        return this.serverName;
    }

    public final String getClientAddress() {
        try {
            InetAddress myInetAddr = InetAddress.getLocalHost();
            byte[] myAddr = myInetAddr.getAddress();
            this.ipStr = "";
            for (int i = 0; i < myAddr.length; ++i) {
                if (i > 0) {
                    this.ipStr = this.ipStr + ".";
                }
                this.ipStr = this.ipStr + (myAddr[i] & 0xFF);
            }
            return this.ipStr;
        }
        catch (UnknownHostException e) {
            return "???.???.???.???";
        }
    }

    public final String getClientName() {
        try {
            InetAddress myInetAddr = InetAddress.getLocalHost();
            return myInetAddr.getHostName();
        }
        catch (UnknownHostException e) {
            return "???";
        }
    }

    public synchronized String getServerAddress() throws ConfigurationException {
        if (null == this.ipStr) {
            try {
                InetAddress address = InetAddress.getByName(this.getServerName());
                byte[] ip = address.getAddress();
                this.ipStr = "";
                for (int i = 0; i < ip.length; ++i) {
                    if (i > 0) {
                        this.ipStr = this.ipStr + ".";
                    }
                    this.ipStr = this.ipStr + (ip[i] & 0xFF);
                }
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel obter o ip do servidor.");
            }
            catch (SecurityException e) {
                throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel obter o ip do servidor.");
            }
        }
        return this.ipStr;
    }

    protected InitialContext createInitialContext(Locale locale) {
        Constructor constructor;
        Class initialContextClass;
        try {
            initialContextClass = this.configuration.getOptionalClassProperty(INITIAL_CONTEXT_CLASS_PROPERTY, InitialContext.class);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException((Throwable)e);
        }
        try {
            constructor = initialContextClass.getConstructor(Locale.class);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel obter o construtor da classe contexto inicial.");
        }
        try {
            return (InitialContext)constructor.newInstance(locale);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel criar o contexto inicial.");
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel criar o contexto inicial.");
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException((Throwable)e, "N\u00e3o foi poss\u00edvel criar o contexto inicial.");
        }
    }

    public final String getHostAddress() {
        String paramName = "client_address";
        String hostAddress = this.getParameter("client_address");
        if (hostAddress != null) {
            return hostAddress;
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return DEFAULT_HOST_ADDRESS;
        }
    }

    public final String getAppAddress() {
        return this.getParameter("app_url");
    }

    public final Locale getDefaultLocale() {
        String paramName = "locale";
        String localeString = this.getParameter("locale");
        if (localeString != null) {
            return FormatUtils.parseLocale((String)localeString);
        }
        return null;
    }

    public final boolean shouldDesktopStartVisible() {
        String paramName = "desktop_visible";
        String paramValue = this.getParameter("desktop_visible");
        if (paramValue != null) {
            String trueValue = String.valueOf(true);
            return trueValue.equals(paramValue);
        }
        return true;
    }

    public final String getStartApplicationId() {
        String paramName = "start_application";
        String paramValue = this.getParameter("start_application");
        if (paramValue == null) {
            return null;
        }
        return paramValue.trim();
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public final JFrame getView() {
        if (this.clientUI == null) {
            return null;
        }
        return this.clientUI.getView();
    }

    public ParameterViewFactory getParameterViewFactory() {
        return this.parameterViewFactory;
    }

    protected void setParameterViewFactory(ParameterViewFactory parameterViewFactory) {
        this.parameterViewFactory = parameterViewFactory;
    }

    public boolean isOpenBusNeeded() {
        return this.loginObject instanceof OpenBusLogin;
    }

    protected final void setLoginObject(LoginInterface loginObject) {
        if (loginObject == null) {
            throw new IllegalStateException("Bad login object set!");
        }
        this.loginObject = loginObject;
    }

    public final LoginInterface getLoginObject() {
        if (this.loginObject == null) {
            throw new IllegalStateException("Bad login object consult!");
        }
        return this.loginObject;
    }

    public String getTextNotFoundInAnyIdiom() {
        StringBuffer textNotFound = new StringBuffer("\n");
        for (String key : this.keyNotFoundInAnyIdiom.keySet()) {
            textNotFound.append(key);
            textNotFound.append(": ");
            textNotFound.append(this.keyNotFoundInSelectedIdiom.get(key));
            textNotFound.append("\n");
        }
        return textNotFound.toString();
    }

    public String getTextNotFoundInSelectedIdiom() {
        StringBuffer textWithoutTranslation = new StringBuffer("\n");
        for (String key : this.keyNotFoundInSelectedIdiom.keySet()) {
            textWithoutTranslation.append(key);
            textWithoutTranslation.append(": ");
            textWithoutTranslation.append(this.keyNotFoundInSelectedIdiom.get(key));
            textWithoutTranslation.append("\n");
        }
        return textWithoutTranslation.toString();
    }

    public void shutdown() {
        if (OpenBusAccessPoint.getInstance() != null && OpenBusAccessPoint.getInstance().isInited()) {
            OpenBusAccessPoint.destroy();
        }
        try {
            System.exit(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final synchronized String generateNewSonId() {
        String sonId = this.getClientInstanceId() + ":" + this.sonCounter;
        ++this.sonCounter;
        return sonId;
    }

    public final synchronized void setServerName(String serverName) {
        this.serverName = serverName;
        this.ipStr = null;
    }

    public int getRMIExportPort() {
        String port = this.getParameter("rmi_port");
        if (port == null) {
            return 0;
        }
        return Integer.valueOf(port);
    }

    public CSDKContextFactory getCSDKContextFactory() {
        return this.csdkContextFactory;
    }

    public String getVersion() {
        return this.clientVersion.getVersionName();
    }
}

