/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.FileListParameterView;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.desktop.DesktopFrame;
import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectFileChooserOpen;
import csbase.client.project.ProjectTreePath;
import csbase.logic.ClientProjectFile;
import csbase.logic.algorithms.parameters.FileListParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import java.awt.Component;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.gui.StandardDialogs;

public final class InputFileListParameterView
extends FileListParameterView {
    @Deprecated
    public InputFileListParameterView(Window window, InputFileListParameter parameter) {
        this(parameter, ParameterView.Mode.CONFIGURATION);
    }

    public InputFileListParameterView(InputFileListParameter parameter, ParameterView.Mode mode) {
        super((FileListParameter)parameter, mode);
    }

    @Override
    public InputFileListParameter getParameter() {
        return (InputFileListParameter)super.getParameter();
    }

    @Override
    protected Set<FileURLValue> askForFile() {
        try {
            HashSet<FileURLValue> files = new HashSet<FileURLValue>();
            ProjectFileChooserOpen chooser = new ProjectFileChooserOpen(this.getWindow(), DesktopFrame.getInstance().getProject(), true, this.getFileChooserMode(), this.getParameter().getFileType(), this.getParameter().usesFilter());
            ProjectTreePath[] projectTreePaths = chooser.getSelectedPaths();
            if (projectTreePaths == null || projectTreePaths.length == 0) {
                return files;
            }
            for (ProjectTreePath projectTreePath : projectTreePaths) {
                ClientProjectFile clientProjectFile = projectTreePath.getFile();
                String type = clientProjectFile.isDirectory() ? "DIRECTORY_TYPE" : clientProjectFile.getType();
                FileURLValue file = new FileURLValue(FileUtils.joinPath((char)'/', (String[])projectTreePath.getPath()), type);
                files.add(file);
            }
            return files;
        }
        catch (ClientException e) {
            String errorMessage = "Ocorreu um erro ao abrir o di\u00e1logo de sele\u00e7\u00e3o de arquivos.";
            if (e.getLocalizedMessage() != null) {
                errorMessage = errorMessage + "\nDetalhes:\n";
                errorMessage = errorMessage + e.getLocalizedMessage();
            }
            StandardDialogs.showErrorDialog((Component)this.getWindow(), (String)"Erro ao abrir o di\u00e1logo de sele\u00e7\u00e3o de arquivo", (String)errorMessage);
            return null;
        }
    }

    protected int getFileChooserMode() {
        int mode;
        FileParameterMode parameterMode = this.getParameter().getMode();
        if (parameterMode.equals((Object)FileParameterMode.REGULAR_FILE)) {
            mode = 0;
        } else if (parameterMode.equals((Object)FileParameterMode.DIRECTORY)) {
            mode = 1;
        } else if (parameterMode.equals((Object)FileParameterMode.DIRECTORY_AND_REGULAR_FILE)) {
            mode = 2;
        } else {
            String errorMessage = MessageFormat.format("O modo {0} n\u00e3o \u00e9 v\u00e1lido.", parameterMode);
            throw new IllegalStateException(errorMessage);
        }
        return mode;
    }
}

