/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ComponentProperties;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.SimpleParameterView;
import csbase.client.algorithms.validation.TableCellValidationResult;
import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.validation.ViewValidator;
import csbase.client.desktop.DesktopFrame;
import csbase.client.util.table.AbstractCellModel;
import csbase.client.util.table.AbstractRowModel;
import csbase.client.util.table.CellModel;
import csbase.client.util.table.CellModelFactory;
import csbase.client.util.table.CellViewFactory;
import csbase.client.util.table.CheckBoxCellView;
import csbase.client.util.table.ComboBoxCellViewFactory;
import csbase.client.util.table.ComboBoxCellViewItem;
import csbase.client.util.table.DoubleConverter;
import csbase.client.util.table.IntegerConverter;
import csbase.client.util.table.ReflectionCellViewFactory;
import csbase.client.util.table.RowValueFactory;
import csbase.client.util.table.Table;
import csbase.client.util.table.TableColumn;
import csbase.client.util.table.TextFieldCellView;
import csbase.client.util.table.TextFieldCellViewFactory;
import csbase.client.util.table.Validator;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.algorithms.parameters.BooleanColumn;
import csbase.logic.algorithms.parameters.Column;
import csbase.logic.algorithms.parameters.DoubleColumn;
import csbase.logic.algorithms.parameters.EnumerationColumn;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.IntegerColumn;
import csbase.logic.algorithms.parameters.RowValue;
import csbase.logic.algorithms.parameters.RowValueListener;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parameters.TableParameterListener;
import csbase.logic.algorithms.parameters.TextColumn;
import csbase.logic.algorithms.parameters.validators.TableParameterValidator;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import tecgraf.javautils.gui.GBC;

public final class TableParameterView
extends SimpleParameterView<List<RowValue>> {
    @Deprecated
    public TableParameterView(Window window, TableParameter parameter) {
        this(parameter, ParameterView.Mode.CONFIGURATION);
    }

    public TableParameterView(TableParameter parameter, ParameterView.Mode mode) {
        super(parameter, mode, new Object[0]);
        this.updateCapabilityView();
        this.updateVisibilyView();
    }

    @Override
    public TableParameter getParameter() {
        return (TableParameter)super.getParameter();
    }

    @Override
    public ViewValidationResult validate(ValidationMode mode) throws RemoteException {
        Object userId;
        TableParameter parameter = this.getParameter();
        TableParameterValidator parameterValidator = (TableParameterValidator)parameter.getParameterValidator();
        CommonClientProject project = DesktopFrame.getInstance().getProject();
        Object projectId = project.getId();
        ValidationContext context = new ValidationContext(mode, projectId, userId = User.getLoggedUser().getId());
        Validation result = parameter.validate(context);
        if (!result.isWellSucceded()) {
            return new TableCellValidationResult(result, this, parameterValidator.getColumnIndex(), parameterValidator.getRowIndex());
        }
        return new ViewValidationResult(result, (ViewValidator)this);
    }

    @Override
    public boolean highlightValidationResult(ViewValidationResult result) {
        if (!result.isWellSucceded() && this.isVisible() && result instanceof TableCellValidationResult) {
            TableCellValidationResult cellValidation = (TableCellValidationResult)result;
            ITableParameterComponent tableComponent = (ITableParameterComponent)((Object)this.getComponent());
            if (tableComponent != null && tableComponent.getRowCount() != 0) {
                tableComponent.selectCell(cellValidation.getRowIndex(), cellValidation.getColumnIndex());
            }
        }
        return super.highlightValidationResult(result);
    }

    @Override
    protected JComponent createConfigurationComponent(Object ... componentArgs) {
        return new TableConfigurationParameter();
    }

    @Override
    protected JComponent createReportComponent(Object ... componentArgs) {
        return new TableReportParameter();
    }

    @Override
    protected void updateViewContents() {
    }

    @Override
    public boolean fillVerticalSpace() {
        return true;
    }

    private final class TableConfigurationParameter
    extends JPanel
    implements ITableParameterComponent {
        private Table<RowValue> table;

        TableConfigurationParameter() {
            this.setLayout(new GridBagLayout());
            List<TableColumn<RowValue>> tableColumns = this.createTableColumns();
            AbstractRowModel<RowValue> rowModel = this.createRowModel();
            this.table = this.createTable(rowModel, tableColumns);
            this.add((Component)this.table.getView(), new GBC(0, 0).both());
        }

        @Override
        public void updateViewContents() {
        }

        @Override
        public int getRowCount() {
            return this.table.getRowCount();
        }

        @Override
        public void selectCell(int rowIndex, int columnIndex) {
            this.table.selectCell(rowIndex, columnIndex);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.table.setEnabled(isEnabled);
        }

        private List<TableColumn<RowValue>> createTableColumns() {
            ArrayList<TableColumn<RowValue>> tableColumns = new ArrayList<TableColumn<RowValue>>(TableParameterView.this.getParameter().getColumnCount());
            List columns = TableParameterView.this.getParameter().getColumns();
            int i = 0;
            while (i < TableParameterView.this.getParameter().getColumnCount()) {
                Column column = (Column)columns.get(i);
                CellViewFactory cellViewFactory = this.createCellViewFactory(column);
                final int columnIndex = i++;
                CellModelFactory<RowValue> cellModelFactory = new CellModelFactory<RowValue>(){

                    @Override
                    public CellModel create(final RowValue rowValue) {
                        final AbstractCellModel cellModel = new AbstractCellModel(){

                            @Override
                            protected void keepValue(Object value) {
                                rowValue.setCellValue(value, columnIndex);
                            }

                            @Override
                            public Object getValue() {
                                return rowValue.getCellValue(columnIndex);
                            }
                        };
                        RowValueListener listener = new RowValueListener(){

                            public void valueWasChanged(Object newValue, int aColumnIndex) {
                                if (aColumnIndex == columnIndex) {
                                    cellModel.setValue(newValue);
                                }
                            }
                        };
                        rowValue.addRowValueListener(listener);
                        return cellModel;
                    }
                };
                TableColumn<RowValue> tableColumn = new TableColumn<RowValue>(column.getLabel(), column.isEditable(), cellModelFactory, cellViewFactory);
                tableColumns.add(tableColumn);
            }
            return tableColumns;
        }

        private AbstractRowModel<RowValue> createRowModel() {
            final AbstractRowModel<RowValue> rowModel = new AbstractRowModel<RowValue>(){

                @Override
                public void addRow(RowValue rowValue) {
                    TableParameterView.this.getParameter().addRow(rowValue);
                    this.fireRowWasAdded(rowValue, TableParameterView.this.getParameter().getRowCount() - 1);
                }

                @Override
                public RowValue getRow(int rowIndex) {
                    return (RowValue)TableParameterView.this.getParameter().getRowValues().get(rowIndex);
                }

                @Override
                public int getRowCount() {
                    return TableParameterView.this.getParameter().getRowCount();
                }

                @Override
                public List<RowValue> getRows() {
                    return TableParameterView.this.getParameter().getRowValues();
                }

                @Override
                public boolean removeRow(int rowIndex) {
                    if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
                        return false;
                    }
                    TableParameterView.this.getParameter().removeRow(rowIndex);
                    return true;
                }
            };
            TableParameterView.this.getParameter().addTableParameterListener(new TableParameterListener(){

                public void rowWasCreated(TableParameter parameter, RowValue newRowValue, int newRowIndex) {
                    rowModel.fireRowWasAdded(newRowValue, newRowIndex);
                }

                public void rowWasRemoved(TableParameter parameter, RowValue oldRowValue, int oldRowIndex) {
                    rowModel.fireRowWasRemoved(oldRowValue, oldRowIndex);
                }
            });
            return rowModel;
        }

        private Table<RowValue> createTable(AbstractRowModel<RowValue> rowModel, List<TableColumn<RowValue>> tableColumns) {
            Table<RowValue> newTable;
            final TableParameter parameter = TableParameterView.this.getParameter();
            if (parameter.hasFixedRowCount()) {
                newTable = new Table<RowValue>(rowModel, tableColumns);
            } else {
                RowValueFactory<RowValue> rowValueFactory = new RowValueFactory<RowValue>(){

                    @Override
                    public RowValue create(int rowIndex) {
                        Object[] values = new Object[parameter.getColumnCount()];
                        for (int i = 0; i < parameter.getColumnCount(); ++i) {
                            Column column = (Column)parameter.getColumns().get(i);
                            values[i] = column.getDefaultValue(rowIndex);
                        }
                        return new RowValue(values);
                    }
                };
                Integer visRowCount = parameter.getVisibleRowCount();
                Integer minRowCount = parameter.getMinRowCount();
                Integer maxRowCount = parameter.getMaxRowCount();
                newTable = new Table<RowValue>(rowValueFactory, rowModel, tableColumns, visRowCount, minRowCount, maxRowCount);
            }
            newTable.setToolTipText(parameter.getDescription());
            return newTable;
        }

        private CellViewFactory createCellViewFactory(Column<?> column) {
            CellViewFactory cellViewFactory;
            if (column instanceof BooleanColumn) {
                cellViewFactory = new ReflectionCellViewFactory(CheckBoxCellView.class);
            } else if (column instanceof IntegerColumn) {
                IntegerConverter integerConverter = new IntegerConverter();
                cellViewFactory = new TextFieldCellViewFactory(TextFieldCellView.HorizontalAlignment.RIGHT, integerConverter, new Validator[0]);
            } else if (column instanceof DoubleColumn) {
                DoubleConverter doubleConverter = new DoubleConverter();
                cellViewFactory = new TextFieldCellViewFactory(TextFieldCellView.HorizontalAlignment.RIGHT, doubleConverter, new Validator[0]);
            } else if (column instanceof TextColumn) {
                cellViewFactory = new TextFieldCellViewFactory(new Validator[0]);
            } else if (column instanceof EnumerationColumn) {
                EnumerationColumn enumerationColumn = (EnumerationColumn)column;
                List items = enumerationColumn.getItems();
                ArrayList<ComboBoxCellViewItem> cellViewItems = new ArrayList<ComboBoxCellViewItem>(items.size());
                for (EnumerationItem item : items) {
                    ComboBoxCellViewItem cellViewItem = new ComboBoxCellViewItem(item.getLabel(), item.getDescription(), item);
                    cellViewItems.add(cellViewItem);
                }
                cellViewFactory = new ComboBoxCellViewFactory(cellViewItems);
            } else {
                throw new IllegalStateException();
            }
            return cellViewFactory;
        }
    }

    private final class TableReportParameter
    extends JPanel
    implements ITableParameterComponent {
        private JTable table;

        TableReportParameter() {
            this.setLayout(new GridLayout());
            this.table = new JTable(new AbstractTableModel(){

                @Override
                public int getColumnCount() {
                    return TableParameterView.this.getParameter().getColumnCount();
                }

                @Override
                public String getColumnName(int column) {
                    return ((Column)TableParameterView.this.getParameter().getColumns().get(column)).getLabel();
                }

                @Override
                public int getRowCount() {
                    return TableParameterView.this.getParameter().getRowCount();
                }

                @Override
                public Class<?> getColumnClass(int c) {
                    return this.getValueAt(0, c).getClass();
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    return TableParameterView.this.getParameter().getItemValue(rowIndex, columnIndex);
                }
            });
            ComponentProperties.setProperties((JComponent)this.table, ParameterView.Mode.REPORT, false);
            JScrollPane scroll = new JScrollPane(this.table);
            scroll.setBorder(ComponentProperties.getInstance(ParameterView.Mode.REPORT).getBorder());
            scroll.setPreferredSize(new Dimension(400, 100));
            this.add((Component)scroll, new GBC(0, 0).both());
            this.updateViewContents();
        }

        @Override
        public void updateViewContents() {
            ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        }

        @Override
        public void selectCell(int rowIndex, int columnIndex) {
            this.table.changeSelection(rowIndex, columnIndex, false, false);
        }

        @Override
        public int getRowCount() {
            return this.table.getRowCount();
        }

        @Override
        public void setEnabled(boolean enabled) {
        }
    }

    private static interface ITableParameterComponent {
        public void updateViewContents();

        public int getRowCount();

        public void selectCell(int var1, int var2);
    }
}

