/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsynchronization;

import csbase.client.applications.projectsynchronization.ContainerSelectionServers;
import csbase.client.applications.projectsynchronization.StepProjectSynchronization;
import csbase.client.applications.projectsynchronization.StepSelectionProjects;
import csbase.logic.ProjectSynchronizationData;
import csbase.logic.ProjectSynchronizationUnit;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.event.DocumentListener;
import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.WasChangedActionListener;
import tecgraf.javautils.gui.wizard.WasChangedDocumentListener;
import tecgraf.javautils.gui.wizard.WizardException;

public class StepSelectionServers
extends StepProjectSynchronization {
    private ContainerSelectionServers containerSelectionServers;
    private ApplicationRegistry registry;

    public StepSelectionServers(ApplicationRegistry registry, String remoteServer, String remotePort) {
        this.registry = registry;
        this.containerSelectionServers = new ContainerSelectionServers(registry, remoteServer, remotePort);
        this.containerSelectionServers.getServerSelectionA().getEServer().getDocument().addDocumentListener((DocumentListener)new WasChangedDocumentListener((Step)this));
        this.containerSelectionServers.getServerSelectionA().getEPassword().getDocument().addDocumentListener((DocumentListener)new WasChangedDocumentListener((Step)this));
        this.containerSelectionServers.getServerSelectionA().getEUser().getDocument().addDocumentListener((DocumentListener)new WasChangedDocumentListener((Step)this));
        this.containerSelectionServers.getServerSelectionA().getEPort().getDocument().addDocumentListener((DocumentListener)new WasChangedDocumentListener((Step)this));
        this.containerSelectionServers.getServerSelectionB().getEServer().getDocument().addDocumentListener((DocumentListener)new WasChangedDocumentListener((Step)this));
        this.containerSelectionServers.getServerSelectionB().getEPort().getDocument().addDocumentListener((DocumentListener)new WasChangedDocumentListener((Step)this));
        this.containerSelectionServers.getServerSelectionB().getEUser().getDocument().addDocumentListener((DocumentListener)new WasChangedDocumentListener((Step)this));
        this.containerSelectionServers.getServerSelectionB().getEPassword().getDocument().addDocumentListener((DocumentListener)new WasChangedDocumentListener((Step)this));
        this.containerSelectionServers.getServerSelectionB().getRdProjectLocal().addActionListener((ActionListener)new WasChangedActionListener((Step)this));
        this.containerSelectionServers.getServerSelectionB().getRdProjectRemote().addActionListener((ActionListener)new WasChangedActionListener((Step)this));
        this.containerSelectionServers.getServerSelectionA().getRdProjectLocal().addActionListener((ActionListener)new WasChangedActionListener((Step)this));
        this.containerSelectionServers.getServerSelectionA().getRdProjectRemote().addActionListener((ActionListener)new WasChangedActionListener((Step)this));
    }

    private boolean isLocalASelected() {
        return this.containerSelectionServers.getServerSelectionA().getRdProjectLocal().isSelected();
    }

    private boolean isLocalBSelected() {
        return this.containerSelectionServers.getServerSelectionB().getRdProjectLocal().isSelected();
    }

    private String getServerA() {
        return this.containerSelectionServers.getServerSelectionA().getEServer().getText();
    }

    private String getPortA() {
        return this.containerSelectionServers.getServerSelectionA().getEPort().getText();
    }

    private String getUserA() {
        return this.containerSelectionServers.getServerSelectionA().getEUser().getText();
    }

    private String getPasswordA() {
        return new String(this.containerSelectionServers.getServerSelectionA().getEPassword().getPassword());
    }

    private String getServerB() {
        return this.containerSelectionServers.getServerSelectionB().getEServer().getText();
    }

    private String getPortB() {
        return this.containerSelectionServers.getServerSelectionB().getEPort().getText();
    }

    private String getUserB() {
        return this.containerSelectionServers.getServerSelectionB().getEUser().getText();
    }

    private String getPasswordB() {
        return new String(this.containerSelectionServers.getServerSelectionB().getEPassword().getPassword());
    }

    protected void enter(History arg0) throws WizardException {
    }

    protected Container getContainer() {
        return this.containerSelectionServers.getRootPanel();
    }

    protected String getInstruction() {
        return this.registry.getString("instruction.step1");
    }

    protected Class getNext(History arg0) {
        return StepSelectionProjects.class;
    }

    protected String getTitle() {
        return this.registry.getString("title.step1");
    }

    @Override
    protected boolean isReady() {
        if (!(this.isLocalASelected() || this.getUserA() != null && this.getUserA().length() != 0 && this.getPasswordA() != null && this.getPasswordA().length() != 0 && this.getServerA() != null && this.getServerA().length() != 0 && this.getPortA() != null && this.getPortA().length() != 0)) {
            return false;
        }
        return this.isLocalBSelected() || this.getUserB() != null && this.getUserB().length() != 0 && this.getPasswordB() != null && this.getPasswordB().length() != 0 && this.getServerB() != null && this.getServerB().length() != 0 && this.getPortB() != null && this.getPortB().length() != 0;
    }

    protected void exit(History history) {
        String port;
        String server;
        Object id;
        String password;
        String login;
        ProjectSynchronizationUnit unitA = null;
        ProjectSynchronizationUnit unitB = null;
        if (this.isLocalASelected()) {
            login = User.getLoggedUser().getLogin();
            password = User.getLoggedUser().getPasswordDigest();
            id = User.getLoggedUser().getId();
            unitA = new ProjectSynchronizationUnit(null, login, password, id);
            history.addGlobal("serverNameA", (Object)"localhost");
        } else {
            login = this.getUserA();
            password = this.getPasswordA();
            server = this.getServerA();
            port = this.getPortA();
            unitA = new ProjectSynchronizationUnit(server + ":" + port, login, password, (Object)login);
            history.addGlobal("serverNameA", (Object)server);
        }
        if (this.isLocalBSelected()) {
            login = User.getLoggedUser().getLogin();
            password = User.getLoggedUser().getPasswordDigest();
            id = User.getLoggedUser().getId();
            unitB = new ProjectSynchronizationUnit(null, login, password, id);
            history.addGlobal("serverNameB", (Object)"localhost");
        } else {
            login = this.getUserB();
            password = this.getPasswordB();
            server = this.getServerB();
            port = this.getPortB();
            unitB = new ProjectSynchronizationUnit(server + ":" + port, login, password, (Object)login);
            history.addGlobal("serverNameB", (Object)server);
        }
        boolean sameProject = false;
        if (this.isLocalASelected() && this.isLocalBSelected()) {
            sameProject = true;
        } else {
            String serverAIP = this.hostToIP(this.getServerA());
            String serverBIP = this.hostToIP(this.getServerB());
            if (this.isLocalASelected() && serverBIP.equalsIgnoreCase("127.0.0.1") || this.isLocalBSelected() && serverAIP.equalsIgnoreCase("127.0.0.1") || serverAIP.equalsIgnoreCase(serverBIP)) {
                sameProject = true;
            }
        }
        history.addGlobal("data", (Object)new ProjectSynchronizationData(unitA, unitB));
        history.addGlobal("sameProjectFlag", (Object)new Boolean(sameProject));
        history.addGlobal("indexA", (Object)new Integer(-1));
        history.addGlobal("indexB", (Object)new Integer(-1));
    }

    private String hostToIP(String host) {
        String ip = "";
        try {
            InetAddress addr = InetAddress.getByName(host);
            byte[] ipAddr = addr.getAddress();
            for (int i = 0; i < ipAddr.length; ++i) {
                if (i > 0) {
                    ip = ip + ".";
                }
                ip = ip + (ipAddr[i] & 0xFF);
            }
        }
        catch (UnknownHostException e) {
            ip = "";
        }
        return ip;
    }
}

