/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileFilter;
import java.util.regex.Pattern;

public class ProjectFileNameAndTypeFilter
implements ProjectFileFilter {
    private final Pattern namePattern;
    private final String fileType;
    private boolean checkDescendant = true;

    public ProjectFileNameAndTypeFilter(String name, String typeCode) {
        this(name, typeCode, true);
    }

    public ProjectFileNameAndTypeFilter(String theName, String typeCode, boolean checkDescendant) {
        if (theName == null) {
            throw new IllegalArgumentException("name == null");
        }
        String name = theName;
        name = name.replaceAll("\\.", "\\\\.");
        name = name.replaceAll("\\?", "\\.");
        if (((name = name.replaceAll("\\*", "\\.\\*")).isEmpty() || name.charAt(name.length() - 1) != '*') && name.indexOf(36) == -1) {
            name = name + ".*";
        }
        this.namePattern = Pattern.compile(name, 2);
        this.fileType = typeCode;
        this.checkDescendant = checkDescendant;
    }

    public boolean accept(ClientProjectFile file) {
        if (this.nameMatches(file) && this.typeMatches(file)) {
            return true;
        }
        if (this.checkDescendant && file.isDirectory()) {
            ClientProjectFile[] children = file.getLocalChildren();
            if (children == null) {
                return false;
            }
            for (ClientProjectFile child : children) {
                if (!this.accept(child)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean nameMatches(ClientProjectFile file) {
        return this.namePattern.matcher(file.getName()).matches();
    }

    private boolean typeMatches(ClientProjectFile file) {
        return this.fileType == null || file.getType().equals(this.fileType);
    }
}

