/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.externalresources;

import csbase.client.externalresources.LocalFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StandaloneLocalFile
implements LocalFile {
    private File file;

    public StandaloneLocalFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        this.file = file;
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream(boolean append) throws IOException {
        return new FileOutputStream(this.file, append);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public StandaloneLocalFile[] listFiles() {
        File[] children = this.file.listFiles();
        if (children == null) {
            return null;
        }
        StandaloneLocalFile[] wrappedChildren = new StandaloneLocalFile[children.length];
        for (int i = 0; i < children.length; ++i) {
            wrappedChildren[i] = new StandaloneLocalFile(children[i]);
        }
        return wrappedChildren;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    public boolean createNewFile() throws IOException {
        return this.file.createNewFile();
    }

    public boolean mkdir() {
        return this.file.mkdir();
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }
}

