/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.TreeFilterPanelListener;
import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeFactory;
import csbase.client.project.ProjectTreeMouseAdapter;
import csbase.client.project.ProjectTreePath;
import csbase.client.project.ProjectTreeSelectionEvent;
import csbase.client.project.ProjectTreeSelectionListener;
import csbase.client.util.ClientUtilities;
import csbase.client.util.CountDown;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;
import csbase.logic.ProjectFileType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public abstract class ProjectFileChooser {
    protected static final String ALL_FILES = LNG.get((String)"UTIL_ALL_FILES");
    public static final int FILE_ONLY = 0;
    public static final int DIRECTORY_ONLY = 1;
    public static final int FILE_AND_DIRECTORY = 2;
    protected ProjectTree projectTree;
    protected JComboBox fileTypeList;
    protected JTextField fileNameText;
    protected ProjectTreePath[] selectedPaths;
    protected DesktopComponentDialog dialog;
    private JButton confirmButton;
    private ProjectTreeSelectionListener treeSelectionListener;
    protected int mode;
    private JLabel fileNameLabel;
    TreeFilterPanel treeFilterPanel;

    protected ProjectFileChooser(Window owner, String title, CommonClientProject project, boolean isMultiSelectionEnabled, int mode, String defaultFileType, ProjectFileFilter visualFilter, ProjectFileFilter selectionFilter, boolean canEditText, String defaultFullFileName, boolean useFilter) throws ClientException {
        this(owner, title, project, isMultiSelectionEnabled, mode, defaultFileType, visualFilter, selectionFilter, canEditText, defaultFullFileName, null, useFilter);
    }

    protected ProjectFileChooser(Window owner, String title, CommonClientProject project, boolean isMultiSelectionEnabled, int mode, String defaultFileType, ProjectFileFilter visualFilter, ProjectFileFilter selectionFilter, boolean canEditText, String defaultFullFileName, String[] currentDirectory, boolean useFilter) throws ClientException {
        this.mode = mode;
        this.dialog = new DesktopComponentDialog(owner, title);
        this.buildProjectTree(title, project, isMultiSelectionEnabled, visualFilter, selectionFilter);
        JPanel contentPanel = new JPanel(new BorderLayout(0, 5));
        contentPanel.add((Component)new JScrollPane(this.projectTree.getTree()), "Center");
        if (useFilter) {
            contentPanel.add((Component)this.makeTextFieldPanel(canEditText), "South");
        } else {
            contentPanel.add((Component)this.makeTextFieldPanel(defaultFileType, canEditText), "South");
        }
        if (useFilter) {
            this.projectTree.setVisualFilter(visualFilter);
            this.treeFilterPanel = new TreeFilterPanel(this.projectTree, defaultFileType, mode);
            this.treeFilterPanel.setVisible(true);
            contentPanel.add((Component)this.treeFilterPanel, "North");
        }
        JPanel mainPanel = new JPanel(new BorderLayout(0, 5));
        mainPanel.add((Component)contentPanel, "Center");
        mainPanel.add((Component)this.makeButtonPanel(), "South");
        this.dialog.getContentPane().add(mainPanel);
        this.dialog.pack();
        this.dialog.center(owner);
        this.dialog.getRootPane().setDefaultButton(this.confirmButton);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProjectFileChooser.this.selectedPaths = null;
                ProjectFileChooser.this.close();
            }
        });
        String[] selectionPath = null;
        String defaultName = null;
        if (defaultFullFileName != null) {
            String[] defaultPath = FileUtils.splitPath((String)defaultFullFileName);
            if (defaultPath.length > 1) {
                selectionPath = new String[defaultPath.length - 1];
                System.arraycopy(defaultPath, 0, selectionPath, 0, defaultPath.length - 1);
            }
            defaultName = defaultPath[defaultPath.length - 1];
        } else if (currentDirectory != null && currentDirectory.length > 0) {
            selectionPath = currentDirectory;
        }
        this.projectTree.setSelectionPath(selectionPath);
        this.fileNameText.requestFocus();
        this.dialog.center();
        if (mode == 0) {
            if (defaultName != null) {
                this.fileNameText.setText(defaultName);
                this.confirmButton.setEnabled(true);
            }
        } else {
            this.confirmButton.setEnabled(true);
            if (mode == 1) {
                this.fileNameText.setVisible(false);
                this.fileNameLabel.setVisible(false);
            } else if (defaultName != null) {
                this.fileNameText.setText(defaultName);
            }
        }
    }

    private JPanel makeButtonPanel() {
        JPanel butPanel = new JPanel();
        this.confirmButton = new JButton(LNG.get((String)"PRJ_FILE_CHOOSER_CONFIRM"));
        this.confirmButton.setEnabled(false);
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProjectFileChooser.this.handleAction()) {
                    ProjectFileChooser.this.close();
                }
            }
        });
        JButton cancelButton = new JButton(LNG.get((String)"PRJ_FILE_CHOOSER_CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectFileChooser.this.selectedPaths = null;
                ProjectFileChooser.this.close();
            }
        });
        ClientUtilities.adjustEqualSizes(this.confirmButton, cancelButton);
        butPanel.add(this.confirmButton);
        butPanel.add(cancelButton);
        return butPanel;
    }

    private JPanel makeTextFieldPanel(String defaultFileType, boolean canEditText) {
        this.fileNameText = new JTextField(30);
        this.fileNameText.setEditable(canEditText);
        this.fileNameLabel = new JLabel(LNG.get((String)"PRJ_FILE_CHOOSER_FILE_NAME"));
        this.fileNameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textChanged();
            }

            public void textChanged() {
                ProjectFileChooser.this.updateConfirmButton();
            }
        });
        JComponent[][] components = null;
        if (this.mode != 1) {
            JLabel fileTypeLabel = new JLabel(LNG.get((String)"PRJ_FILE_CHOOSER_FILTER_NAME"));
            ProjectFileType[] fTypes = ProjectFileType.getAllFileTypes();
            this.fileTypeList = new JComboBox<ProjectFileType>(new DefaultComboBoxModel<ProjectFileType>(fTypes));
            this.fileTypeList.addItem(ALL_FILES);
            if (defaultFileType != null) {
                this.fileTypeList.setSelectedItem(ProjectFileType.getFileType((String)defaultFileType));
            } else {
                this.fileTypeList.setSelectedItem(ALL_FILES);
            }
            this.fileTypeList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object selectedFileType = ProjectFileChooser.this.fileTypeList.getSelectedItem();
                    ProjectFileFilter filter = selectedFileType.equals(ALL_FILES) ? ProjectFileChooser.this.getVisualFilter() : ProjectFileChooser.this.getVisualFilter(((ProjectFileType)ProjectFileChooser.this.fileTypeList.getSelectedItem()).getCode());
                    ProjectFileChooser.this.projectTree.setVisualFilter(filter);
                    filter = selectedFileType.equals(ALL_FILES) ? ProjectFileChooser.this.getSelectionFilter() : ProjectFileChooser.this.getSelectionFilter(((ProjectFileType)ProjectFileChooser.this.fileTypeList.getSelectedItem()).getCode());
                    ProjectFileChooser.this.projectTree.setSelectionFilter(filter);
                    ProjectFileChooser.this.updateConfirmButton();
                }
            });
            components = new JComponent[][]{{this.fileNameLabel, this.fileNameText}, {fileTypeLabel, this.fileTypeList}};
        } else {
            components = new JComponent[][]{{this.fileNameLabel, this.fileNameText}};
        }
        JPanel txtPanel = GUIUtils.createBasicGridPanel((JComponent[][])components);
        return txtPanel;
    }

    private JPanel makeTextFieldPanel(boolean canEditText) {
        this.fileNameText = new JTextField(30);
        this.fileNameText.setEditable(canEditText);
        this.fileNameLabel = new JLabel(LNG.get((String)"PRJ_FILE_CHOOSER_FILE_NAME"));
        this.fileNameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textChanged();
            }

            public void textChanged() {
                ProjectFileChooser.this.updateConfirmButton();
            }
        });
        JComponent[][] components = null;
        components = new JComponent[][]{{this.fileNameLabel, this.fileNameText}};
        JPanel txtPanel = GUIUtils.createBasicGridPanel((JComponent[][])components);
        return txtPanel;
    }

    private void updateConfirmButton() {
        if (this.mode == 0) {
            boolean hasFilename = this.fileNameText.getText().trim().length() > 0;
            this.confirmButton.setEnabled(hasFilename && this.getSelectedPath() != null);
        } else {
            this.confirmButton.setEnabled(this.getSelectedPath() != null);
        }
    }

    protected abstract boolean handleAction();

    private void buildProjectTree(String title, CommonClientProject project, boolean isMultiSelectionEnabled, ProjectFileFilter visualFilter, ProjectFileFilter selectionFilter) throws ClientException {
        this.projectTree = ProjectTreeFactory.getInstance().makeProjectTree(this.dialog, title, project, visualFilter, selectionFilter);
        this.projectTree.setSingleSelectionMode(!isMultiSelectionEnabled);
        this.projectTree.getTree().addMouseListener(new ProjectTreeMouseAdapter(this.projectTree){

            @Override
            public void doubleClickAction(ClientProjectFile file) {
                if (ProjectFileChooser.this.handleAction()) {
                    ProjectFileChooser.this.close();
                }
            }
        });
        this.treeSelectionListener = new ProjectTreeSelectionListener(){

            @Override
            public void update(ProjectTreeSelectionEvent event) {
                ProjectFileChooser.this.makeSelection(event.getSelectedFiles());
                ProjectFileChooser.this.updateConfirmButton();
            }
        };
        this.projectTree.addTreeSelectionListener(this.treeSelectionListener);
    }

    protected abstract void makeSelection(ClientProjectFile[] var1);

    protected abstract ProjectFileFilter getVisualFilter();

    protected abstract ProjectFileFilter getVisualFilter(String var1);

    protected abstract ProjectFileFilter getVisualFilter(String var1, String var2);

    protected abstract ProjectFileFilter getSelectionFilter();

    protected abstract ProjectFileFilter getSelectionFilter(String var1);

    protected abstract ProjectFileFilter getSelectionFilter(String var1, String var2);

    public ProjectTreePath getSelectedPath() {
        if (this.selectedPaths == null || this.selectedPaths.length == 0) {
            return null;
        }
        return this.selectedPaths[this.selectedPaths.length - 1];
    }

    private void close() {
        this.projectTree.removeTreeSelectionListener(this.treeSelectionListener);
        this.projectTree.release();
        this.dialog.close();
    }

    protected ClientProjectFile getSelectedFile() {
        return this.projectTree.getSelectedFile();
    }

    protected ClientProjectFile[] getSelectedFiles() {
        return this.projectTree.getSelectedFiles();
    }

    public ProjectTreePath[] getSelectedPaths() {
        return this.selectedPaths;
    }

    protected String getTitle() {
        return null;
    }

    public class TreeFilterPanel
    extends JPanel {
        private static final long TEXTFIELD_COUNT_DOWN = 1L;
        private final TimeUnit TEXTFIELD_COUNT_DOWN_UNIT;
        private JTextField filterTextField;
        private JComboBox typeComboBox;
        private ProjectTree projectTree;
        private JButton clearFieldButton;
        private List<TreeFilterPanelListener> listeners;

        public TreeFilterPanel(ProjectTree tree, String defaultFileType, int mode) {
            super(new GridBagLayout());
            this.TEXTFIELD_COUNT_DOWN_UNIT = TimeUnit.SECONDS;
            this.listeners = new ArrayList<TreeFilterPanelListener>();
            this.projectTree = tree;
            this.filterTextField = new JTextField(10);
            this.filterInput(this.filterTextField);
            this.filterTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    TreeFilterPanel.this.clearFieldButton.setEnabled(TreeFilterPanel.this.filterTextField.getText().length() > 0);
                }
            });
            this.filterTextField.setToolTipText(LNG.get((String)"TreeFilterPanel.filterTextField.tooltip"));
            this.filterTextField.addKeyListener(new KeyAdapter(){
                final CountDown countDown;
                {
                    this.countDown = new CountDown(1L, TreeFilterPanel.this.TEXTFIELD_COUNT_DOWN_UNIT, new Runnable(){

                        @Override
                        public void run() {
                            SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    TreeFilterPanel.this.filterTree();
                                }
                            });
                        }
                    });
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    this.countDown.restart();
                }
            });
            this.clearFieldButton = new JButton(ApplicationImages.ICON_CLEARMSG_16);
            this.clearFieldButton.setMargin(new Insets(0, 0, 0, 0));
            this.clearFieldButton.setEnabled(false);
            this.clearFieldButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeFilterPanel.this.filterTextField.setText("");
                    TreeFilterPanel.this.clearFieldButton.setEnabled(false);
                    TreeFilterPanel.this.filterTextField.requestFocusInWindow();
                    TreeFilterPanel.this.filterTree();
                }
            });
            ProjectFileType[] fTypes = ProjectFileType.getAllFileTypes();
            DefaultComboBoxModel<ProjectFileType> cmbModel = new DefaultComboBoxModel<ProjectFileType>(fTypes);
            this.typeComboBox = new JComboBox<ProjectFileType>(cmbModel);
            this.typeComboBox.addItem(ALL_FILES);
            if (defaultFileType != null && !defaultFileType.isEmpty()) {
                this.typeComboBox.setSelectedItem(ProjectFileType.getFileType((String)defaultFileType));
                this.filterTree();
            } else {
                this.typeComboBox.setSelectedItem(ALL_FILES);
            }
            this.typeComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeFilterPanel.this.filterTree();
                }
            });
            JPanel entryPanel = new JPanel(new GridBagLayout());
            Insets margins = new Insets(5, 5, 5, 5);
            TitledBorder border = BorderFactory.createTitledBorder(LNG.get((String)"TreeFilterPanel.border.title"));
            entryPanel.setBorder(border);
            entryPanel.add((Component)new JLabel(LNG.get((String)"TreeFilterPanel.label.name")), new GBC(0, 0).insets(margins).west());
            entryPanel.add((Component)this.filterTextField, new GBC(1, 0).insets(margins).west().weightx(1.0).horizontal());
            entryPanel.add((Component)this.clearFieldButton, new GBC(2, 0).insets(margins).west());
            entryPanel.add((Component)new JLabel(LNG.get((String)"TreeFilterPanel.label.type")), new GBC(0, 1).insets(margins).west());
            entryPanel.add((Component)this.typeComboBox, new GBC(1, 1).insets(margins).west().weightx(1.0).width(2).horizontal());
            this.add((Component)entryPanel, new GBC(0, 0).both());
        }

        private void filterInput(final Component cmp) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent e) {
                    boolean discardEvent = false;
                    if (e.getID() == 400 && cmp.isFocusOwner() && !this.isValid(e.getKeyChar())) {
                        discardEvent = true;
                    }
                    return discardEvent;
                }

                private boolean isValid(char keyChar) {
                    if (Character.isLetterOrDigit(keyChar)) {
                        return true;
                    }
                    return "?*$._".indexOf(keyChar) >= 0;
                }
            });
        }

        private void filterTree() {
            String nameFilter = this.filterTextField.getText();
            String typeFilter = this.typeComboBox.getSelectedItem().equals(ALL_FILES) ? null : ((ProjectFileType)this.typeComboBox.getSelectedItem()).getCode();
            ProjectFileFilter filter = ProjectFileChooser.this.getVisualFilter(nameFilter, typeFilter);
            this.projectTree.setVisualFilter(filter);
            filter = ProjectFileChooser.this.getSelectionFilter(nameFilter, typeFilter);
            this.projectTree.setSelectionFilter(filter);
        }

        public void addListener(TreeFilterPanelListener l) {
            this.listeners.add(l);
        }

        public boolean removeListener(TreeFilterPanelListener l) {
            return this.listeners.remove(l);
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.filterTextField.requestFocusInWindow();
            } else {
                String filterText = this.filterTextField.getText();
                this.filterTextField.setText(null);
                if (!filterText.isEmpty() || !this.typeComboBox.getSelectedItem().equals(ALL_FILES)) {
                    this.typeComboBox.setSelectedItem(ALL_FILES);
                }
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).visibilityChanged(this.isVisible());
            }
        }
    }
}

