/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser.util;

import csbase.client.ClientLocalFile;
import csbase.client.desktop.DesktopFrame;
import csbase.client.util.filechooser.images.ChooserImages;
import csbase.logic.ClientFile;
import csbase.logic.ClientFileType;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;

public class ClientFileChooserUtils {
    public static final ClientLocalFile getLocalHomeDirectory() {
        String prop = System.getProperty("user.home");
        if (prop == null) {
            return null;
        }
        File home = new File(prop);
        if (!home.exists()) {
            return null;
        }
        ClientLocalFile localHomeFile = new ClientLocalFile(home);
        return localHomeFile;
    }

    public static final List<ClientLocalFile> getLocalRootDirectories() {
        File[] roots;
        ArrayList<ClientLocalFile> rootFiles = new ArrayList<ClientLocalFile>();
        for (File file : roots = File.listRoots()) {
            rootFiles.add(new ClientLocalFile(file));
        }
        Collections.sort(rootFiles, new Comparator<ClientLocalFile>(){

            @Override
            public int compare(ClientLocalFile f1, ClientLocalFile f2) {
                return f1.getStringPath().compareTo(f2.getStringPath());
            }
        });
        return rootFiles;
    }

    public static final ClientLocalFile getLocalRootDirectory(ClientFile currentDir) {
        if (currentDir == null || currentDir.getClientFileType() != ClientFileType.LOCAL) {
            return ClientFileChooserUtils.getLocalRootDirectories().iterator().next();
        }
        ClientLocalFile elem = (ClientLocalFile)currentDir;
        while (elem.getParent() != null) {
            elem = elem.getParent();
        }
        return elem;
    }

    public static final ClientFile getProjectHomeDirectory() {
        DesktopFrame desktop = DesktopFrame.getInstance();
        CommonClientProject project = desktop.getProject();
        if (project == null) {
            return null;
        }
        ClientProjectFile directory = project.getRoot();
        return directory;
    }

    public static final boolean isLocalHomeDirectory(ClientFile file) {
        ClientLocalFile home = ClientFileChooserUtils.getLocalHomeDirectory();
        if (home == null) {
            return false;
        }
        if (!(file instanceof ClientLocalFile)) {
            return false;
        }
        ClientLocalFile localFile = (ClientLocalFile)file;
        return home.equals(localFile);
    }

    public static final boolean isProjectHomeDirectory(ClientFile file) {
        ClientFile home = ClientFileChooserUtils.getProjectHomeDirectory();
        if (home == null) {
            return false;
        }
        return home.equals(file);
    }

    public static final boolean isLocalRootDirectory(ClientFile file) {
        if (file.getClientFileType() == ClientFileType.LOCAL) {
            for (ClientFile clientFile : ClientFileChooserUtils.getLocalRootDirectories()) {
                if (!clientFile.equals(file)) continue;
                return true;
            }
        }
        return false;
    }

    public static final ImageIcon getDirectoryImageIcon(ClientFile file) {
        if (ClientFileChooserUtils.isLocalHomeDirectory(file)) {
            return ChooserImages.LOCAL_HOME_ICON;
        }
        if (ClientFileChooserUtils.isProjectHomeDirectory(file)) {
            return ChooserImages.PROJECT_HOME_ICON;
        }
        if (ClientFileChooserUtils.isLocalRootDirectory(file)) {
            return ChooserImages.LOCAL_ROOT_ICON;
        }
        if (file.getClientFileType() == ClientFileType.REMOTE) {
            return ChooserImages.PROJECT_DIRECTORY_ICON;
        }
        if (ClientFileChooserUtils.isHiddenFile(file)) {
            return ChooserImages.DIRECTORY_GRAY_ICON;
        }
        if (!file.canExecute()) {
            if (!file.canRead() && !file.canWrite()) {
                return ChooserImages.FOLDER_NO_PERMISSION_IMG;
            }
            return ChooserImages.LOCKED_DIRECTORY_ICON;
        }
        if (!file.canRead()) {
            return ChooserImages.DIRECTORY_GRAY_ICON;
        }
        return ChooserImages.DIRECTORY_ICON;
    }

    public static String getDirectoryName(ClientFile directory) {
        if (ClientFileChooserUtils.isProjectHomeDirectory(directory)) {
            return directory.getName() + "/";
        }
        if (ClientFileChooserUtils.isLocalRootDirectory(directory)) {
            return directory.getStringPath();
        }
        return directory.getName();
    }

    public static boolean isHiddenFile(ClientFile file) {
        String name = file.getName();
        return name.startsWith(".");
    }
}

