/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.table;

import csbase.client.util.table.AbstractCellView;
import csbase.client.util.table.ComboBoxCellViewItem;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class ComboBoxCellView
extends AbstractCellView {
    private List<ComboBoxCellViewItem> availableItems;
    private JComboBox comboBox;
    private ComboBoxCellViewItem selectedItem;

    public ComboBoxCellView(List<ComboBoxCellViewItem> availableItems) {
        this.setAvailableItems(availableItems);
        this.createComboBox();
    }

    @Override
    public String getTip() {
        if (this.selectedItem == null) {
            return null;
        }
        return this.selectedItem.getTip();
    }

    @Override
    public Object getValue() {
        ComboBoxCellViewItem item = (ComboBoxCellViewItem)this.comboBox.getSelectedItem();
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    @Override
    public JComponent getView() {
        return this.comboBox;
    }

    @Override
    protected void keepValue(Object value) {
        for (ComboBoxCellViewItem item : this.availableItems) {
            if (!item.getValue().equals(value)) continue;
            this.comboBox.setSelectedItem(item);
            return;
        }
        throw new IllegalArgumentException(String.format("O item da combobox cujo valor \u00e9 %s n\u00e3o foi encontrado.", value));
    }

    private void createComboBox() {
        this.comboBox = new JComboBox();
        this.comboBox.setModel(this.createComboBoxModel());
        this.comboBox.setRenderer(this.createListCellRenderer());
        this.comboBox.getModel().addListDataListener(this.createListDataListener());
    }

    private ListDataListener createListDataListener() {
        return new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (ComboBoxCellView.this.selectedItem != null) {
                    ComboBoxCellView.this.comboBox.setToolTipText(ComboBoxCellView.this.selectedItem.getTip());
                } else {
                    ComboBoxCellView.this.comboBox.setToolTipText(null);
                }
                ComboBoxCellView.this.fireValueWasChanged();
            }
        };
    }

    private ComboBoxModel createComboBoxModel() {
        return new ComboBoxModel(){
            private List<ListDataListener> listeners = new LinkedList<ListDataListener>();

            @Override
            public void addListDataListener(ListDataListener l) {
                this.listeners.add(l);
            }

            @Override
            public Object getElementAt(int index) {
                return ComboBoxCellView.this.availableItems.get(index);
            }

            @Override
            public Object getSelectedItem() {
                return ComboBoxCellView.this.selectedItem;
            }

            @Override
            public int getSize() {
                return ComboBoxCellView.this.availableItems.size();
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
                this.listeners.remove(l);
            }

            @Override
            public void setSelectedItem(Object anItem) {
                ComboBoxCellView.this.selectedItem = (ComboBoxCellViewItem)anItem;
                for (ListDataListener listener : this.listeners) {
                    listener.contentsChanged(new ListDataEvent(ComboBoxCellView.this.comboBox, 0, -1, 1));
                }
            }
        };
    }

    private DefaultListCellRenderer createListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ComboBoxCellViewItem item = (ComboBoxCellViewItem)value;
                if (item != null) {
                    this.setText(item.getLabel());
                    if (item.getTip() != null) {
                        this.setToolTipText(item.getTip());
                    }
                }
                return component;
            }
        };
    }

    private void setAvailableItems(List<ComboBoxCellViewItem> availableItems) {
        if (availableItems == null) {
            throw new IllegalArgumentException("O par\u00e2metro availableItems est\u00e1 nulo.");
        }
        if (availableItems.isEmpty()) {
            throw new IllegalArgumentException("O par\u00e2metro availableItems est\u00e1 vazio.");
        }
        this.availableItems = new ArrayList<ComboBoxCellViewItem>(availableItems);
        Collections.sort(this.availableItems);
    }
}

