package csbase.client.applications.flowapplication.actions;

import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.graph.UniformSizeGraphLayout;

/**
 * Ao de aplicar o {@link UniformSizeGraphLayout} no fluxo corrente.
 */
public class UniformSizeLayoutAction extends GraphLayoutAction {

  /**
   * Construtor.
   * 
   * @param application A aplicao construtura de fluxos.
   */
  public UniformSizeLayoutAction(FlowApplication application) {
    super(application, FlowApplicationUI.UNIFORM_SIZE_LAYOUT_ICON,
      new UniformSizeGraphLayout());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean usePreview() {
    return false;
  }

}
