/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop.projectoccupation;

import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.util.MonitoringTheme;
import csbase.logic.CommonClientProject;
import csbase.logic.diskusageservice.DiskOccupation;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.DiskUsageServiceInterface;
import java.awt.Color;
import java.awt.Font;
import java.rmi.RemoteException;
import javax.swing.JProgressBar;
import javax.swing.plaf.basic.BasicProgressBarUI;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class ProjectOccupationProgressBar
extends JProgressBar {
    private final ProjectTree projectTree;
    private final Thread thread;
    protected boolean alive = false;
    private int intervalSec;
    private int alertValue = 90;
    private int warningValue = 75;
    private Color warningColor = MonitoringTheme.getRangeWarningColor();
    private Color normalColor = MonitoringTheme.getRangeDefaultColor();
    private Color alertColor = MonitoringTheme.getRangeAlertColor();
    private long lastRefresh;

    private void addProjectTreeListeners() {
        this.projectTree.addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject proj) {
                ProjectOccupationProgressBar.this.refresh(true);
            }
        });
    }

    private void autoRefresh() {
        while (this.alive) {
            long now = System.currentTimeMillis();
            long delta = now - this.lastRefresh;
            long deltaSec = Math.round((double)delta / 1000.0);
            if (deltaSec >= (long)this.intervalSec) {
                this.refresh(false);
                deltaSec = this.intervalSec;
            }
            try {
                Thread.sleep(deltaSec * 1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private Thread createAutoThread() {
        Thread th = new Thread(){

            @Override
            public void run() {
                ProjectOccupationProgressBar.this.autoRefresh();
            }
        };
        String className = this.getClass().getSimpleName();
        long tag = System.currentTimeMillis();
        String threadName = className + "::" + tag;
        th.setName(threadName);
        return th;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    public final Color getAlertColor() {
        return this.alertColor;
    }

    public final int getAlertValue() {
        return this.alertValue;
    }

    public final int getIntervalSec() {
        return this.intervalSec;
    }

    public final Color getNormalColor() {
        return this.normalColor;
    }

    private String getString(String tag, Object ... args) {
        String prefix = this.getClass().getSimpleName();
        String key = prefix + "." + tag;
        String fmt = LNG.get((String)key);
        String text = String.format(fmt, args);
        return text;
    }

    public final Color getWarningColor() {
        return this.warningColor;
    }

    public final int getWarningValue() {
        return this.warningValue;
    }

    public final void refresh(boolean forced) {
        if (forced) {
            this.lastRefresh = 0L;
        }
        long now = System.currentTimeMillis();
        long delta = now - this.lastRefresh;
        int minIntervalMiliSeconds = 1000;
        if (delta < 1000L) {
            return;
        }
        this.lastRefresh = now;
        if (this.projectTree == null || this.projectTree.getProject() == null) {
            this.setData(false, "no-prj", "no-prj", Color.white, 100);
            return;
        }
        DiskOccupation occ = this.getCurrentProjectOccupation();
        if (!occ.isValid()) {
            String text = this.getString("invalid.text", new Object[0]);
            String tooltip = this.getString("invalid.tooltip", new Object[0]);
            this.setData(true, text, tooltip, Color.white, 100);
            return;
        }
        double percUsed = occ.getUsedSpacePerc();
        double gbFree = occ.getFreeSpaceMb() / 1024.0;
        double gbUsed = occ.getUsedSpaceMb() / 1024.0;
        double gbTotal = occ.getTotalSpaceMb() / 1024.0;
        int value = (int)Math.round(percUsed);
        Color color = this.normalColor;
        if (value > this.warningValue) {
            color = this.warningColor;
        }
        if (value > this.alertValue) {
            color = this.alertColor;
        }
        String txtTag = "normal.text";
        String text = this.getString("normal.text", percUsed, gbUsed, gbFree, gbTotal);
        String tipTag = "normal.tooltip";
        String tooltip = this.getString("normal.tooltip", percUsed, gbUsed, gbFree, gbTotal);
        this.setData(true, text, tooltip, color, value);
    }

    private DiskOccupation getCurrentProjectOccupation() {
        DesktopFrame desktop = DesktopFrame.getInstance();
        CommonClientProject project = desktop.getProject();
        if (project == null) {
            return new DiskOccupation();
        }
        DiskOccupation occ = SwingThreadDispatcher.isEventDispatchThread() ? this.getOccupationByTask(project) : this.getOccupationDirect(project);
        return occ;
    }

    private DiskOccupation getOccupationDirect(CommonClientProject project) {
        DiskUsageServiceInterface diskUsageService = ClientRemoteLocator.diskUsageService;
        Object owner = project.getUserId();
        String projectName = project.getName();
        try {
            DiskOccupation serverOccupation = diskUsageService.getSingleProjectOccupation(owner, projectName);
            return serverOccupation;
        }
        catch (RemoteException e) {
            return new DiskOccupation();
        }
    }

    private DiskOccupation getOccupationByTask(final CommonClientProject project) {
        RemoteTask<DiskOccupation> task = new RemoteTask<DiskOccupation>(){

            public void performTask() throws Exception {
                DiskUsageServiceInterface diskUsageService = ClientRemoteLocator.diskUsageService;
                Object owner = project.getUserId();
                String projectName = project.getName();
                DiskOccupation serverOccupation = diskUsageService.getSingleProjectOccupation(owner, projectName);
                this.setResult(serverOccupation);
            }

            @Override
            protected void handleError(Exception error) {
                this.setResult(null);
            }
        };
        task.setProgressDialogDelay(60);
        task.execute(DesktopFrame.getInstance().getDesktopFrame(), "", "Disk: " + project.getName());
        DiskOccupation occ = (DiskOccupation)task.getResult();
        return occ;
    }

    private void setData(final boolean visible, final String text, final String tooltip, final Color foreground, final int value) {
        if (!SwingThreadDispatcher.isEventDispatchThread()) {
            SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProjectOccupationProgressBar.this.setDataInEDT(visible, text, tooltip, foreground, value);
                }
            });
        } else {
            this.setDataInEDT(visible, text, tooltip, foreground, value);
        }
    }

    private void setDataInEDT(boolean visible, String text, String tooltip, Color foreground, int value) {
        this.setVisible(visible);
        this.setToolTipText(tooltip);
        this.setString(text);
        this.setForeground(foreground);
        this.setValue(value);
    }

    public final void setAlertColor(Color alertColor) {
        this.alertColor = alertColor;
    }

    public final void setAlertValue(int alertValue) {
        this.alertValue = alertValue;
    }

    public final void setIntervalSec(int intervalSec) {
        this.intervalSec = intervalSec;
        this.refresh(false);
    }

    public final void setNormalColor(Color normalColor) {
        this.normalColor = normalColor;
    }

    public final void setWarningColor(Color warningColor) {
        this.warningColor = warningColor;
    }

    public final void setWarningValue(int warningValue) {
        this.warningValue = warningValue;
    }

    public final void shutdown() {
        this.alive = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public ProjectOccupationProgressBar(ProjectTree projectTree, boolean automatic) {
        this.projectTree = projectTree;
        this.intervalSec = 60;
        this.setFont(new Font("SansSerif", 0, 10));
        this.addProjectTreeListeners();
        this.setBorderPainted(true);
        this.setStringPainted(true);
        this.setUI(new BasicProgressBarUI(){

            @Override
            protected Color getSelectionBackground() {
                return Color.black;
            }

            @Override
            protected Color getSelectionForeground() {
                return Color.black;
            }
        });
        if (automatic) {
            this.lastRefresh = System.currentTimeMillis();
            this.thread = this.createAutoThread();
            this.alive = true;
            this.thread.start();
        } else {
            this.alive = false;
            this.thread = null;
        }
        this.refresh(true);
    }
}

