package csbase.client.applications.algorithmsmanager.actions;

import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmVersionInfoPanel;
import csbase.client.applications.algorithmsmanager.dialogs.VersionDialog;
import csbase.client.applications.algorithmsmanager.versiontree.PropertiesPanel;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmProperty;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * Essa classe representa a ao de remover uma verso de algoritmo, na
 * funcionalidade de gerenciamento de algoritmos.
 * 
 * O mtodo <code> handleEditOperation </code> deve ser redefinido para que seja
 * aberto o dilogo para confirmao da remoo da verso do algoritmo.
 * 
 */
public class VersionCreateAction extends CommonVersionAction {
  /**
   * Constri a ao de importar um pacote de verso de algoritmo.
   * 
   * @param versionInfoPanel painel pai que criou a ao
   * @param icon imagem da ao
   */
  public VersionCreateAction(AlgorithmVersionInfoPanel versionInfoPanel,
    ImageIcon icon) {
    super(versionInfoPanel, icon);
    setEnabled(true);
  }

  @Override
  protected void handleVersionOperation() {
    new AddVersionDialog().show();
  }

  /**
   * Classe que representa um dilogo de incluso de verso.
   * 
   * @author Leonardo Barros
   */
  private class AddVersionDialog extends VersionDialog {
    /** Nome dos atributos */
    private List<AlgorithmProperty> versionProperties;
    /** Painel de propriedades da verso */
    private PropertiesPanel propertiesPanel;

    /**
     * Cria o dilogo.
     */
    public AddVersionDialog() {
      super(getSelectedAlgorithm());
      versionProperties =
        AlgorithmManagementProxy.getAlgorithmVersionProperties(getWindow());
      propertiesPanel =
        new PropertiesPanel(versionProperties, new Hashtable<String, String>(),
          LNG.get("algomanager.label.optional_properties"), getWindow(), true);
    }

    /**
     * Mostra o dilogo.
     */
    public void show() {
      dialogTitle =
        String.format(LNG.get("algomanager.title.include_version"),
          algoInfo.getName());
      dialog = new DesktopComponentDialog(getWindow());
      dialog.setTitle(dialogTitle);
      dialog.addWindowListener(new WindowAdapter() {
        @Override
        public void windowClosing(WindowEvent e) {
          dialog.close();
        }
      });

      /* Painel com informacoes obrigatorias */
      JPanel mainInfoPanel = new JPanel(new GridBagLayout());
      JLabel idLabel = new JLabel(LNG.get("algomanager.label.version_id"));
      majorField = new JTextField(3);
      minorField = new JTextField(3);
      patchField = new JTextField(3);
      mainInfoPanel
        .add(idLabel, new GBC(0, 0).none().west().insets(5, 5, 5, 5));
      mainInfoPanel.add(majorField,
        new GBC(1, 0).none().west().insets(5, 5, 5, 5));
      mainInfoPanel.add(minorField,
        new GBC(2, 0).none().west().insets(5, 5, 5, 5));
      mainInfoPanel.add(patchField,
        new GBC(3, 0).none().west().insets(5, 5, 5, 5));

      /* Painel com os dois paineis */
      JPanel infoPanel = new JPanel(new GridBagLayout());
      infoPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
      // infoPanel.setLayout(new BoxLayout(infoPanel, BoxLayout.Y_AXIS));
      // infoPanel.add(mainInfoPanel);
      infoPanel.add(mainInfoPanel,
        new GBC(0, 0).none().west().insets(5, 5, 5, 5));
      if (versionProperties.size() > 0) {
        // infoPanel.add(propertiesPanel.getPropertiesPanel());
        infoPanel.add(propertiesPanel.getPropertiesPanel(), new GBC(0, 1)
          .none().west().insets(5, 5, 5, 5));
      }
      /* Painel com os botoes */
      JPanel buttonsPanel = new JPanel();
      JButton includeButton =
        new JButton(LNG.get("algomanager.button.include"));
      includeButton.addActionListener(new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
          int[] vNumbers = getVersionNumbers();
          if (vNumbers != null && propertiesPanel.validateProperties()) {
            createVersion(vNumbers[0], vNumbers[1], vNumbers[2]);
            dialog.close();
          }
        }
      });

      JButton cancelButton = new JButton(LNG.get("algomanager.button.cancel"));
      cancelButton.addActionListener(new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
          dialog.close();
        }
      });
      ClientUtilities.adjustEqualSizes(includeButton, cancelButton);
      buttonsPanel.add(includeButton);
      buttonsPanel.add(cancelButton);
      dialog.add(infoPanel, BorderLayout.CENTER);
      dialog.add(buttonsPanel, BorderLayout.SOUTH);
      dialog.pack();
      dialog.center(getWindow());
      dialog.setVisible(true);
    }

    /**
     * Cria uma verso de algoritmo no repositrio.
     * 
     * @param major nmero de verso
     * @param minor nmero de reviso
     * @param patch nmero de correo
     */
    private void createVersion(int major, int minor, int patch) {
      AlgorithmInfo algo =
        AlgorithmManagementProxy.createVersion(algoInfo.getId(), major, minor,
          patch, propertiesPanel.getProperties(), getWindow());
      Object id = AlgorithmVersionInfo.getIdFor(major, minor, patch);
      if (algo == null) {
        StandardErrorDialogs.showErrorDialog(dialog,
          LNG.get("algomanager.title.error") + " - " + dialogTitle,
          MessageFormat.format(LNG.get("algomanager.error.version_include"),
            new Object[] { id }));
      }
    }
  }

}
