package csbase.client.applications.algorithmsmanager.versiontree.datatransfer;

import java.awt.datatransfer.Transferable;

import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;

/**
 * Esta classe tem como objetivo armazenar objetos a serem transferidos,
 * evitando assim o uso do clipboard, uma vez que seu acesso no  permitido
 * para Applets.
 */
public class VersionTreeClipboard {

  // Instncia nica desta classe.
  private static VersionTreeClipboard instance = null;

  /** Objeto a ser transferido */
  private Transferable transferable;

  private synchronized static final VersionTreeClipboard getInstance() {
    if (instance == null) {
      instance = new VersionTreeClipboard();
    }
    return instance;
  }

  /**
   * Obtm o objeto sendo transferido.
   * 
   * @return o objeto sendo transferido. Se no houver nenhum, <tt>null</tt>
   *         ser retornado.
   */
  public static final Transferable getObject() {
    return getInstance().transferable;
  }

  /**
   * Atribui um objeto a ser transferido.
   * 
   * @param transferable objeto a ser transferido ou null caso queira limpar o
   *        clipboard.
   */
  public static final void setObject(Transferable transferable) {
    getInstance().transferable = transferable;
  }

  static {
    RestartManager.getInstance().addListener(new RestartListener() {
      public void restart() {
        VersionTreeClipboard.instance = null;
      }
    });
  }
}
