package csbase.client.applications.flowapplication;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;

import csbase.exception.BugException;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * 
 * 
 * 
 * @author lmoreira
 */
public final class AlgorithmVersionTransferable implements Transferable {
  /**
   * Flavor
   */
  public static final DataFlavor DATA_FLAVOR;

  static {
    try {
      DATA_FLAVOR =
        new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType + ";class="
          + AlgorithmVersionInfo.class.getName());
    }
    catch (final ClassNotFoundException e) {
      throw new BugException(e);
    }
  }

  /**
   * Verso.
   */
  private final AlgorithmVersionInfo version;

  /**
   * Construtor
   * 
   * @param version verso.
   */
  public AlgorithmVersionTransferable(final AlgorithmVersionInfo version) {
    if (version == null) {
      throw new IllegalArgumentException("O parmetro version est nulo.");
    }
    this.version = version;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataFlavor[] getTransferDataFlavors() {
    return new DataFlavor[] { DATA_FLAVOR };
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isDataFlavorSupported(final DataFlavor flavor) {
    if (DATA_FLAVOR.equals(flavor)) {
      return true;
    }
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public AlgorithmVersionInfo getTransferData(final DataFlavor flavor)
    throws UnsupportedFlavorException {
    if (!isDataFlavorSupported(flavor)) {
      throw new UnsupportedFlavorException(flavor);
    }
    return this.version;
  }
}
