package csbase.client.applications.projectsynchronization;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.MessageFormat;

import javax.swing.JEditorPane;

import csbase.remote.ProjectSynchronizationMonitor;

/**
 * Monitor para sincronizao de projetos. Para cada arquivo transferido entre
 * projetos, a rea de texto do painel  atualizado com uma mensagem de sucesso
 * ou erro caso tenho ocorrido.
 */
public class ProjectSynchronizationWizardMonitor extends UnicastRemoteObject
  implements ProjectSynchronizationMonitor {
  /** rea de texto do resultado */
  private JEditorPane textArea;
  /** Texto j inserido na textArea */
  private StringBuffer text;
  /** Aplicao de sincronizao */
  private ProjectSynchronization application;
  /** Indica se a sincronizao foi cancelada */
  private boolean cancelled = false;

  /**
   * Construtor.
   * 
   * @param textArea rea de texto do resultado
   * @param text texto j inserido na textArea
   * @param application apliao de sincronizao
   * @throws RemoteException
   */
  protected ProjectSynchronizationWizardMonitor(JEditorPane textArea,
    StringBuffer text, ProjectSynchronization application)
    throws RemoteException {
    super();
    this.application = application;
    this.text = text;
    this.textArea = textArea;
    this.text.append(application
      .getString("ProjectSynchronizationWizardMonitor.result.head"));
    this.text.append("<BR><BR>");
    this.textArea.setText(text.toString());
  }

  public void partialResult(String[] file, String result)
    throws RemoteException {
    StringBuffer sb = new StringBuffer();
    for (int i = 0; i < file.length; i++) {
      sb.append(file[i]);
      if (i < (file.length - 1)) {
        sb.append("/");
      }
    }
    String msg;
    if (result == null) {
      msg =
        MessageFormat.format(application.getString("msg.transfer"),
          new Object[] { sb.toString() });
    }
    else {
      msg =
        MessageFormat.format(application.getString("msg.transfer.error"),
          new Object[] { sb.toString(), result });
    }
    text.append(msg);
    text.append("<BR>");
    // Passamos a no alterar a interface a cada passo, para melhorar o desempenho da transferncia.
    //    String newText = text.toString() + "<BR></BODY></HTML>";
    //    textArea.setText(newText);
  }

  public void finalResult(String result) throws RemoteException {
    if (result != null) {
      text.append("<BR><HR><BR>");
      text.append(result);
      text.append("<BR></BODY></HTML>");
      textArea.setText(text.toString());
    }
    else {
      // Atualizamos o textArea com o resultado no fim da sincronizao
      textArea.setText(text.toString());
    }
  }

  public boolean isCancelled() throws RemoteException {
    return cancelled;
  }

  /**
   * Altera o estado para cancelado e altera o painel de resultados.
   */
  public void setCancelled() {
    text.append("<BR><HR><BR>");
    text.append(application.getString("canceling"));
    String newText = text.toString() + "<BR></BODY></HTML>";
    textArea.setText(newText);
    this.cancelled = true;
  }

  public void initTransfer(String file) throws RemoteException {
    ProjectSynchronizationRemoteTask task = application.getTask();
    if (task != null) {
      task.setStepText(file);
    }
  }
}
