/*
 * Detalhes da ltima alterao:
 *
 * $Author: rodrigoh $
 * $Date: 2006-01-24 14:49:30 -0200 (Tue, 24 Jan 2006) $
 * $Revision: 36482 $
 */
package csbase.client.login;

import java.util.Locale;

/**
 * <p>
 * Representa o contexto inicial de execuo da interface de usurio.
 * </p>
 * 
 * <p>
 * IMPORTANTE: Toda subclasse de {@link InitialContext} deve possuir um
 * construtor pblico que receba um Locale como parmetro.
 * </p>
 *
 * @author Tecgraf/PUC-Rio
 */
public class InitialContext {
  /** O locale definido para execuo da interface de usurio. */
  private Locale locale;

  /**
   * Cria o contexto inicial de execuo da interface de usurio.
   *
   * @param locale O locale definido para execuo da interface de usurio.
   */
  public InitialContext(Locale locale) {
    this.locale = locale;
  }

  /**
   * Obtm o locale definido para execuo da interface de usurio.
   *
   * @return O locale definido para execuo da interface de usurio.
   */
  public final Locale getLocale() {
    return this.locale;
  }
}
