/**
 * ProjectTreeTransferHandler.java $Author: mjulia $ $Revision: 144754 $  -
 * $Date: 2013-09-19 18:38:30 -0300 (Thu, 19 Sep 2013) $
 */
package csbase.client.project;

import java.awt.Window;
import java.awt.datatransfer.DataFlavor;

import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

import csbase.logic.ClientProjectFile;

/**
 * A classe <code>ProjectTreeTransferHandler</code>  responsvel por
 * transferir objetos <code>ProjectFile</code> da rvore de projeto. A
 * transferncia pode ser efetuada pelas operaes copiar, recortar e colar
 * de/para o clipboard.  tambm usada pela operao de drag&drop sobre os ns
 * da rvore.
 *
 * @author Julia
 */
public class ProjectTreeTransferHandler extends AbstractProjectFileTransferHandler {

  /**
   * Constri um handler de transferncia de objetos de uma rvore de  projeto.
   *
   * @param ownerWindow A janela sobre a qual uma DesktopTask deve ser
   *        efetuada.
   * @param ownerTitle O ttulo da janela de DesktopTask
   */
  public ProjectTreeTransferHandler(Window ownerWindow, String ownerTitle) {
    super(ownerWindow, ownerTitle);
  }
  
  /**
   * Verifica se o componente pode fazer importao.
   *
   * @param c O componente sobre o qual a transferncia foi iniciada.
   * @param flavor Os formatos de dados dos objetos que esto sendo
   *        transferidos.
   *
   * @return Verdadeiro, se o componente permite iniciar a transferncia dos
   *         objetos com o formato especificado.
   */
  @Override
  public boolean canImport(JComponent c, DataFlavor[] flavor) {
    if (!(c instanceof JTree)) {
      return false;
    }
    JTree tree = (JTree)c;
    if (tree.getEditingPath() != null) {
      return false;
    }
 
    return super.canImport(c, flavor);
  }  

  @Override
  protected ClientProjectFile[] getFilesToExport(JComponent source) {
    if (source instanceof JTree) {
      JTree tree = (JTree)source;
      
      TreePath[] path = tree.getSelectionPaths();
      if (path.length > 0) {
        ClientProjectFile[] files = new ClientProjectFile[path.length];
        for (int inx = 0; inx < path.length; inx++) {
          ProjectTreeNode selectedNode =
            (ProjectTreeNode)path[inx].getLastPathComponent();
          files[inx] = selectedNode.getClientProjectFile();
        }
        return files;
      }
    }
    return null;
  }

  @Override
  protected ClientProjectFile getDestinationDirectory(JComponent destination) {
    if (destination instanceof JTree) {    
      JTree tree = (JTree)destination;
      
      TreePath path = tree.getSelectionPath();
      ProjectTreeNode selectedNode = (ProjectTreeNode)path.getLastPathComponent();
      return selectedNode.getClientProjectFile();
    }
    else {
      return null;
    }
  }

}
 