/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.ClientLocalFile;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.URLParameterView;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil;
import csbase.client.util.filechooser.ClientSGAFileChooserUtil;
import csbase.client.util.filechooser.util.ClientFileChooserUtils;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import csbase.logic.ClientSGAFile;
import csbase.logic.SGASet;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.InputURLParameter;
import csbase.logic.algorithms.parameters.URLParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import java.text.MessageFormat;
import java.util.LinkedList;
import tecgraf.javautils.core.lng.LNG;

public class InputURLParameterView
extends URLParameterView {
    public InputURLParameterView(InputURLParameter parameter, ParameterView.Mode mode) {
        super((URLParameter)parameter, mode);
    }

    @Override
    public InputURLParameter getParameter() {
        return (InputURLParameter)super.getParameter();
    }

    @Override
    protected FileURLValue askForFile(URLProtocol fileProtocol, Object ... args) {
        String fileType = this.getParameter().getFileType();
        ClientFileChooserSelectionMode selectionMode = this.getFileChooserMode();
        String title = this.getParameter().getLabel();
        switch (fileProtocol) {
            case PROJECT: {
                return this.askForProjectFile(fileType, selectionMode, title);
            }
            case LOCAL: {
                return this.askForLocalFile(fileType, selectionMode, title);
            }
            case SGA: {
                String sgaName = (String)args[0];
                return this.askForSGAFile(fileType, selectionMode, title, sgaName);
            }
        }
        return null;
    }

    private FileURLValue askForProjectFile(String fileType, ClientFileChooserSelectionMode selectionMode, String title) {
        ClientProjectFileChooserUtil.OperationResult result = ClientProjectFileChooserUtil.browseSingleInOpenMode(this.getWindow(), title, selectionMode, true, fileType, new String[0]);
        if (result != null) {
            ClientProjectFile dir = result.getClientProjectFile();
            return this.getURLFromFile(URLProtocol.PROJECT, (ClientFile)dir, null);
        }
        return null;
    }

    private FileURLValue askForLocalFile(String fileType, ClientFileChooserSelectionMode selectionMode, String title) {
        LinkedList<String> fileTypes = new LinkedList<String>();
        if (fileType != null) {
            fileTypes.add(fileType);
        }
        switch (selectionMode) {
            case DIRECTORIES_ONLY: {
                ClientLocalFile localDir = ClientLocalFileChooserUtil.browseSingleDirectoryInOpenMode(this.getWindow(), fileTypes, title, true, ClientFileChooserUtils.getLocalHomeDirectory());
                return this.getURLFromFile(URLProtocol.LOCAL, localDir, null);
            }
            case FILES_ONLY: {
                ClientLocalFile localFile = ClientLocalFileChooserUtil.browseSingleFileInOpenMode(this.getWindow(), fileTypes, title, true, ClientFileChooserUtils.getLocalHomeDirectory());
                return this.getURLFromFile(URLProtocol.LOCAL, localFile, null);
            }
        }
        return null;
    }

    private FileURLValue askForSGAFile(String fileType, ClientFileChooserSelectionMode selectionMode, String title, final String sgaName) {
        if (sgaName == null) {
            return null;
        }
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        RemoteTask<Boolean> sgaIsAliveTask = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                SGASet sga = sgaService.getSGASet(sgaName);
                this.setResult(sga.getAlive());
            }
        };
        boolean isAlive = false;
        String description = LNG.get((String)(URLParameterView.class.getSimpleName() + ".sga_alive_task"));
        if (sgaIsAliveTask.execute(this.getWindow(), title, description)) {
            isAlive = (Boolean)sgaIsAliveTask.getResult();
        }
        if (!isAlive) {
            String errorMessage = LNG.get((String)(URLParameterView.class.getSimpleName() + ".sga_not_alive"), (Object[])new Object[]{sgaName});
            StandardErrorDialogs.showErrorDialog(this.getWindow(), errorMessage);
            return null;
        }
        LinkedList<String> fileTypes = new LinkedList<String>();
        if (fileType != null) {
            fileTypes.add(fileType);
        }
        ClientSGAFile root = new ClientSGAFile(sgaName, "/");
        switch (selectionMode) {
            case DIRECTORIES_ONLY: {
                ClientSGAFile dir = ClientSGAFileChooserUtil.browseSingleDirectoryInOpenMode(this.getWindow(), fileTypes, title, true, root);
                return this.getURLFromFile(URLProtocol.SGA, (ClientFile)dir, sgaName);
            }
            case FILES_ONLY: {
                ClientSGAFile file = ClientSGAFileChooserUtil.browseSingleFileInOpenMode(this.getWindow(), fileTypes, title, true, root);
                return this.getURLFromFile(URLProtocol.SGA, (ClientFile)file, sgaName);
            }
        }
        return null;
    }

    private FileURLValue getURLFromFile(URLProtocol fileProtocol, ClientFile file, String host) {
        if (file == null) {
            return null;
        }
        String type = file.getType();
        return new FileURLValue(file.getStringPath(), type, fileProtocol, host);
    }

    private ClientFileChooserSelectionMode getFileChooserMode() {
        FileParameterMode parameterMode = this.getParameter().getMode();
        switch (parameterMode) {
            case REGULAR_FILE: {
                return ClientFileChooserSelectionMode.FILES_ONLY;
            }
            case DIRECTORY: {
                return ClientFileChooserSelectionMode.DIRECTORIES_ONLY;
            }
        }
        String errorMessage = MessageFormat.format("O modo {0} n\u00e3o \u00e9 v\u00e1lido.", parameterMode);
        throw new IllegalStateException(errorMessage);
    }
}

