/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.jobmonitor;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationComponentDialog;
import csbase.client.applications.jobmonitor.JobMonitor;
import csbase.client.applications.jobmonitor.rowmodel.JobInfoRow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class JobInfoDialog
extends ApplicationComponentDialog<JobMonitor>
implements Observer {
    private Map<String, JTextComponent> rowAttributes;

    public JobInfoDialog(JobMonitor app, JobInfoRow jobInfoRow) {
        super(app);
        this.setTitle(app.getString("details.title"));
        this.rowAttributes = new LinkedHashMap<String, JTextComponent>();
        this.buildInterface(jobInfoRow);
    }

    private void buildInterface(JobInfoRow jobInfoRow) {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        Object app = this.getApplication();
        JButton close = new JButton(((Application)app).getString("button.close"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobInfoDialog.this.setVisible(false);
            }
        });
        container.add((Component)this.createPropertyPanel(jobInfoRow), new GBC(0, 0).both().insets(10));
        container.add((Component)close, new GBC(0, 1).none().bottom(10).right(10).east());
        this.setMinimumSize(new Dimension(700, 500));
    }

    private JScrollPane createPropertyPanel(JobInfoRow selectedRow) {
        JPanel panel = new JPanel(new GridBagLayout());
        int verticalIndex = 0;
        for (Map.Entry<String, String> entry : selectedRow.entrySet()) {
            JTextComponent value;
            String columnName = entry.getKey();
            String columnValue = entry.getValue();
            JLabel property = new JLabel(columnName);
            String valueStr = columnValue.toString();
            if (valueStr != null && valueStr.length() > 40) {
                value = new JTextArea(valueStr, 1, 40);
                ((JTextArea)value).setLineWrap(true);
                value.setOpaque(false);
                value.setBorder(UIManager.getBorder("TextField.border"));
            } else {
                value = new JTextField(valueStr);
            }
            value.setEditable(false);
            this.rowAttributes.put(entry.getKey(), value);
            panel.add((Component)property, new GBC(0, verticalIndex).insets(3).east());
            panel.add((Component)value, new GBC(1, verticalIndex++).horizontal().insets(3));
        }
        panel.add((Component)new JLabel(), new GBC(0, verticalIndex).both());
        return new JScrollPane(panel);
    }

    @Override
    public void update(Observable o, Object arg) {
        JobMonitor app = (JobMonitor)o;
        final JobInfoRow row = app.getSelectedObject();
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (row != null) {
                    for (Map.Entry<String, String> entry : row.entrySet()) {
                        String columnName = entry.getKey();
                        String value = entry.getValue();
                        JTextComponent field = (JTextComponent)JobInfoDialog.this.rowAttributes.get(columnName);
                        if (field == null) continue;
                        field.setText(value.toString());
                    }
                }
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            ((JobMonitor)this.getApplication()).deleteObserver(this);
        }
        super.setVisible(visible);
    }
}

