/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.serverdiagnostic.properties;

import csbase.client.applications.serverdiagnostic.properties.PropertiesTableModel;
import csbase.logic.diagnosticservice.PropertyInfo;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.table.SortableTable;

public class PropertiesTable
extends SortableTable {
    private static final String NO_VALUE = "--";
    private JPanel detailPanel;
    private PropertyInfo[] propertiesInfo;
    private JLabel serviceValueLabel = new JLabel("--");
    private JLabel serverValueLabel = new JLabel("--");
    private JLabel systemValueLabel = new JLabel("--");
    private JLabel commandLineValueLabel = new JLabel("--");

    public PropertiesTable(PropertyInfo[] propertiesInfo, boolean createDetailPanel) {
        this.propertiesInfo = propertiesInfo;
        PropertiesTableModel model = new PropertiesTableModel(this.propertiesInfo);
        this.setModel(model);
        this.setRowSelectionAllowed(true);
        this.getSelectionModel().setSelectionMode(0);
        if (createDetailPanel) {
            this.detailPanel = this.makeDetailPanel();
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (event.getValueIsAdjusting()) {
                        return;
                    }
                    PropertiesTable.this.updateDetailPanel();
                }
            });
        }
        this.setComparator(0, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return PropertiesTable.this.compareStringsWithNumbers(o1, o2);
            }
        });
        this.sort();
    }

    private int compareStringsWithNumbers(String s1, String s2) {
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher1 = pattern.matcher(s1);
        Matcher matcher2 = pattern.matcher(s2);
        if (matcher1.find() && matcher2.find()) {
            String str2;
            String str1;
            int result;
            int m2;
            int m1 = matcher1.start();
            if (m1 > 0 ^ (m2 = matcher2.start()) > 0) {
                return s1.compareTo(s2);
            }
            if (m1 > 0 && m2 > 0 && (result = (str1 = s1.substring(0, m1 - 1).toString()).compareTo(str2 = s2.substring(0, m2 - 1).toString())) != 0) {
                return result;
            }
            String number1 = matcher1.group();
            String number2 = matcher2.group();
            Double d1 = Double.parseDouble(number1);
            Double d2 = Double.parseDouble(number2);
            int result2 = Double.compare(d1, d2);
            if (result2 == 0) {
                return this.compareStringsWithNumbers(s1.substring(matcher1.start() + number1.length()), s2.substring(matcher2.start() + number2.length()));
            }
            return result2;
        }
        return s1.compareTo(s2);
    }

    private JPanel makeDetailPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(LNG.get((String)"PropertiesTable.service.label")), new GBC(0, 0).none().west().insets(5, 5, 0, 0));
        panel.add((Component)this.serviceValueLabel, new GBC(1, 0).horizontal().west().insets(5, 5, 0, 0));
        panel.add((Component)new JLabel(LNG.get((String)"PropertiesTable.server.label")), new GBC(0, 1).none().west().insets(5, 5, 0, 0));
        panel.add((Component)this.serverValueLabel, new GBC(1, 1).horizontal().west().insets(5, 5, 0, 0));
        panel.add((Component)new JLabel(LNG.get((String)"PropertiesTable.system.label")), new GBC(0, 2).none().west().insets(5, 5, 0, 0));
        panel.add((Component)this.systemValueLabel, new GBC(1, 2).horizontal().west().insets(5, 5, 0, 0));
        panel.add((Component)new JLabel(LNG.get((String)"PropertiesTable.command.line.label")), new GBC(0, 3).none().west().insets(5, 5, 5, 0));
        panel.add((Component)this.commandLineValueLabel, new GBC(1, 3).horizontal().west().insets(5, 5, 5, 0));
        panel.setBorder(BorderFactory.createTitledBorder(LNG.get((String)"PropertiesTable.detail.title")));
        return panel;
    }

    private void updateDetailPanel() {
        int row = this.getSelectedRow();
        if (row < 0) {
            this.serviceValueLabel.setText(NO_VALUE);
            this.serverValueLabel.setText(NO_VALUE);
            this.systemValueLabel.setText(NO_VALUE);
            this.commandLineValueLabel.setText(NO_VALUE);
        } else {
            this.serviceValueLabel.setText(this.propertiesInfo[row].serviceValue == null ? NO_VALUE : this.propertiesInfo[row].serviceValue);
            this.serverValueLabel.setText(this.propertiesInfo[row].serverValue == null ? NO_VALUE : this.propertiesInfo[row].serverValue);
            this.systemValueLabel.setText(this.propertiesInfo[row].systemValue == null ? NO_VALUE : this.propertiesInfo[row].systemValue);
            this.commandLineValueLabel.setText(this.propertiesInfo[row].commandLineValue == null ? NO_VALUE : this.propertiesInfo[row].commandLineValue);
        }
    }

    public JPanel getPropertiesDetailPanel() {
        return this.detailPanel;
    }
}

