/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeListener;
import csbase.client.project.ProjectTreeNode;
import csbase.client.project.action.CommonFileOpenAction;
import csbase.logic.ClientProjectFile;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public abstract class ProjectTreeMouseAdapter
extends MouseAdapter {
    private ProjectTree projectTree;

    @Override
    public void mouseReleased(MouseEvent me) {
        ClientProjectFile file = this.getFileFromEventPath(me);
        if (file != null && me.isPopupTrigger()) {
            int mex = me.getX();
            int mey = me.getY();
            this.showPopupMenu(file, mex, mey);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        ClientProjectFile file = this.getFileFromEventPath(me);
        if (file != null && me.getClickCount() == 2) {
            this.doubleClickAction(file);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int mex = me.getX();
        int mey = me.getY();
        ClientProjectFile file = this.getFileFromEventPath(me);
        if (file != null && me.isPopupTrigger()) {
            this.showPopupMenu(file, mex, mey);
        }
    }

    public abstract void doubleClickAction(ClientProjectFile var1);

    protected final void fireOpenAction(ClientProjectFile file) {
        CommonFileOpenAction openAction = new CommonFileOpenAction(this.projectTree);
        openAction.openFile(file);
    }

    private ClientProjectFile getFileFromEventPath(MouseEvent me) {
        int mex = me.getX();
        int mey = me.getY();
        TreePath path = this.getTree().getPathForLocation(mex, mey);
        if (path == null) {
            return null;
        }
        ProjectTreeNode lastPathComponent = (ProjectTreeNode)path.getLastPathComponent();
        ClientProjectFile file = lastPathComponent.getClientProjectFile();
        return file;
    }

    private void showPopupMenu(ClientProjectFile file, int mex, int mey) {
        JTree tree = this.getTree();
        if (tree.getSelectionCount() > 1) {
            if (this.projectTree.getPopupMultSelection() != null) {
                this.notifyPopupMultSelectionWasTriggered();
                this.projectTree.getPopupMultSelection().show(tree, mex, mey);
            }
        } else {
            TreePath path = this.getTree().getPathForLocation(mex, mey);
            tree.setSelectionPath(path);
            if (file.isDirectory()) {
                if (file.getParent() == null && this.projectTree.getPopupRoot() != null) {
                    this.notifyPopupRootWasTriggered();
                    this.projectTree.getPopupRoot().show(tree, mex, mey);
                } else if (this.projectTree.getPopupDir() != null) {
                    this.notifyPopupDirWasTriggered(file);
                    this.projectTree.getPopupDir().show(tree, mex, mey);
                }
                return;
            }
            if (this.projectTree.getPopupFile() != null) {
                this.notifyPopupFileWasTriggered(file);
                this.projectTree.getPopupFile().show(tree, mex, mey);
            }
        }
    }

    private void notifyPopupMultSelectionWasTriggered() {
        Vector<ProjectTreeListener> listeners = this.projectTree.getListeners();
        for (ProjectTreeListener listener : listeners) {
            listener.popupMultSelectionTriggered();
        }
    }

    private void notifyPopupRootWasTriggered() {
        Vector<ProjectTreeListener> listeners = this.projectTree.getListeners();
        for (ProjectTreeListener listener : listeners) {
            listener.popupRootTriggered();
        }
    }

    private void notifyPopupDirWasTriggered(ClientProjectFile dir) {
        Vector<ProjectTreeListener> listeners = this.projectTree.getListeners();
        for (ProjectTreeListener listener : listeners) {
            listener.popupDirTriggered(dir);
        }
    }

    private void notifyPopupFileWasTriggered(ClientProjectFile file) {
        Vector<ProjectTreeListener> listeners = this.projectTree.getListeners();
        for (ProjectTreeListener listener : listeners) {
            listener.popupFileTriggered(file);
        }
    }

    public ProjectTreeMouseAdapter(ProjectTree projectTree) {
        this.projectTree = projectTree;
    }

    private JTree getTree() {
        return this.projectTree.getTree();
    }
}

