/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies.messageservice;

import csbase.client.ClientServerManager;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.remote.srvproxies.messageservice.consumers.AdaptableMessageConsumer;
import csbase.client.remote.srvproxies.messageservice.consumers.IMessageConsumer;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.CSBaseException;
import csbase.remote.ClientRemoteLocator;
import csbase.util.data.channel.DataChannel;
import csbase.util.data.dispatcher.DispatcherAdapter;
import csbase.util.data.dispatcher.ExecutorDispatcher;
import csbase.util.data.dispatcher.IDispatchListener;
import csbase.util.data.dispatcher.IDispatcher;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import csbase.util.messages.MessageListenerDispatcher;
import csbase.util.messages.filters.BodyTypeFilter;
import java.awt.Window;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import tecgraf.javautils.core.filter.CompositeFilter;
import tecgraf.javautils.core.filter.IFilter;
import tecgraf.javautils.core.lng.LNG;

public class MessageProxy {
    public static final int DEFAULT_TIME_TO_LIVE = 10;
    private static AdaptableMessageConsumer consumer = new AdaptableMessageConsumer();
    private static IMessageConsumer.IListener consumerListener;
    private static DataChannel<IMessageListener, Message> channel;
    private static Map<IMessageListener, IFilter<Message>> filtersByListener;

    public static void clearListeners() {
        consumer.clearListener();
        channel.unsubscribeAll();
        filtersByListener.clear();
    }

    public static void send(Message message, String ... usersLogin) throws CSBaseException, RemoteException {
        long timeToLive = TimeUnit.DAYS.toMillis(10L);
        MessageProxy.send(message, timeToLive, usersLogin);
    }

    public static void send(Message message, long timeToLive, String ... usersLogin) throws CSBaseException, RemoteException {
        ClientRemoteLocator.messageService.send(message, timeToLive, usersLogin);
    }

    public static void sendLocal(Message message) {
        channel.publish((Object[])new Message[]{message});
    }

    public static void broadcast(Message message) throws CSBaseException, RemoteException {
        long timeToLive = TimeUnit.DAYS.toMillis(10L);
        MessageProxy.broadcast(message, timeToLive);
    }

    public static void broadcast(Message message, long timeToLive) throws CSBaseException, RemoteException {
        ClientRemoteLocator.messageService.broadcast(message, timeToLive);
    }

    public static synchronized void addListener(IMessageListener listener, IFilter<Message> filter) {
        channel.subscribe((Object)listener, filter);
        filtersByListener.put(listener, filter);
        MessageProxy.onFiltersChanged();
    }

    public static void addListener(IMessageListener listener, Class<?> bodyType) {
        BodyTypeFilter filter = new BodyTypeFilter(bodyType);
        MessageProxy.addListener(listener, (IFilter<Message>)filter);
    }

    public static synchronized void removeListener(IMessageListener listener) {
        channel.unsubscribe((Object)listener);
        filtersByListener.remove(listener);
        MessageProxy.onFiltersChanged();
    }

    private static void onFiltersChanged() {
        Collection<IFilter<Message>> filters = filtersByListener.values();
        if (filters.size() == 0) {
            consumer.clearListener();
        } else {
            CompositeFilter composedFilter = new CompositeFilter(filters);
            consumer.setListener(consumerListener, (IFilter<Message>)composedFilter);
        }
    }

    private static void showError(String msg, Exception e) {
        String title = LNG.get((String)"ERRO") + " - " + LNG.get((String)"MESSAGE_PROXY_TITLE");
        DesktopComponentFrame window = null;
        DesktopFrame mainFrame = DesktopFrame.getInstance();
        if (mainFrame != null) {
            window = mainFrame.getDesktopFrame();
        }
        if (e != null) {
            StandardErrorDialogs.showErrorDialog(window, title, msg, e);
        } else {
            StandardErrorDialogs.showErrorDialog((Window)window, title, msg);
        }
    }

    static {
        filtersByListener = new HashMap<IMessageListener, IFilter<Message>>();
        ExecutorDispatcher dispatcher = new ExecutorDispatcher((ExecutorService)new ThreadPoolExecutor(0, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()), (IDispatcher)new MessageListenerDispatcher());
        DispatcherAdapter<IMessageListener, Message> dispatchListener = new DispatcherAdapter<IMessageListener, Message>(){

            public void onExceptionThrown(Exception e, IMessageListener listener, Message ... messages) {
                channel.unsubscribe((Object)listener);
                filtersByListener.remove(listener);
                MessageProxy.onFiltersChanged();
            }
        };
        channel = new DataChannel((IDispatcher)dispatcher, (IDispatchListener)dispatchListener);
        consumerListener = new IMessageConsumer.IListener(){

            @Override
            public void onMessagesReceived(Message ... messages) {
                channel.publish((Object[])messages);
            }

            @Override
            public void onExceptionThrown(Exception e) {
                if (e instanceof RemoteException) {
                    ClientServerManager.getInstance().invalidate();
                }
            }
        };
    }
}

