/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.table;

import csbase.client.util.table.RowModel;
import csbase.client.util.table.RowModelListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractRowModel<R>
implements RowModel<R> {
    private List<RowModelListener<R>> listeners = new LinkedList<RowModelListener<R>>();

    protected AbstractRowModel() {
    }

    @Override
    public void addRowModelListener(RowModelListener<R> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public final void fireRowWasAdded(R newRowValue, int newRowIndex) {
        for (RowModelListener<R> listener : this.listeners) {
            listener.rowWasAdded(newRowValue, newRowIndex);
        }
    }

    public final void fireRowWasRemoved(R oldRowValue, int oldRowIndex) {
        for (RowModelListener<R> listener : this.listeners) {
            listener.rowWasRemoved(oldRowValue, oldRowIndex);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    @Override
    public Iterator<R> iterator() {
        return this.getRows().iterator();
    }

    @Override
    public boolean removeRowModelListener(RowModelListener<R> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        return this.listeners.remove(listener);
    }
}

