package csbase.client.applications.algorithmsmanager.actions;

import java.awt.event.ActionEvent;
import java.util.List;

import javax.swing.ImageIcon;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmVersionInfoPanel;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * Ao que remove uma ou mais verses de um algoritmo.
 * 
 * @author Tecgraf
 */
public class VersionRemoveAction extends AlgorithmsManagerAction {

  /** Painel com as informaes de verses de um algoritmo. */
  private AlgorithmVersionInfoPanel versionInfoPanel;

  /**
   * Constri a ao de remover verso de algoritmo.
   * 
   * @param versionInfoPanel - painel pai que criou a ao.
   * @param icon - imagem da ao.
   */
  public VersionRemoveAction(AlgorithmVersionInfoPanel versionInfoPanel,
    ImageIcon icon) {
    super(versionInfoPanel.getApplication(), icon);
    this.versionInfoPanel = versionInfoPanel;
    setEnabled(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    List<AlgorithmVersionInfo> versions =
      versionInfoPanel.getSelectedVersions();
    if (confirmRemove(versions)) {
      for (AlgorithmVersionInfo i : versions) {
        AlgorithmInfo info = i.getInfo();

        AlgorithmManagementProxy.removeVersion(info.getId(), i.getId(),
          getApplication().getApplicationFrame());
      }
    }
  }

  /**
   * Retorna true se o usurio confirmou a remoo das verses de algoritmos,
   * false caso contrrio.
   * 
   * @param versions - lista com as verses selecionadas.
   * @return true se o usurio confirmou a remoo das verses de algoritmos,
   *         false caso contrrio.
   */
  private boolean confirmRemove(List<AlgorithmVersionInfo> versions) {
    int opt = -1;

    Object[] options =
      { getString("VersionRemoveAction.button.remove"),
          getString("VersionRemoveAction.button.cancel") };

    if (versions.size() == 1) {
      String dialogTitle =
        getString("VersionRemoveAction.title.remove.version");

      AlgorithmVersionInfo algoVersion = versions.get(0);

      opt =
        StandardDialogs.showOptionDialog(
          getApplication().getApplicationFrame(), dialogTitle, getClassString(
            "VersionRemoveAction.confirm.remove.version", algoVersion.getId()),
          options);
    }
    else {
      String dialogTitle =
        getString("VersionRemoveAction.title.remove.versions");

      opt =
        StandardDialogs.showOptionDialog(
          getApplication().getApplicationFrame(), dialogTitle,
          getString("VersionRemoveAction.confirm.remove.versions"), options);
    }

    return opt == 0;
  }
}
