/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree.datatransfer;

import java.awt.datatransfer.DataFlavor;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         Contrato de uma rea passvel de receber objetos importados do
 *         {@link VersionTreeTransferHandler}.
 */
public interface ITransferableTarget {

  /**
   * Indica se aceita a importao daqueles dados.
   * 
   * @param data Dados a serem importados.
   * @param flavor {@DataFlavor} indicando o que eles representam.
   * 
   * @return <tt>true</tt> se aceitar a importao destes dados.
   */
  boolean canImport(Object[] data, DataFlavor flavor);

  /**
   * Importa os dados.
   * 
   * @param data dados a serem importados.
   * 
   * @return <tt>true</tt> se a importao ocorreu com sucesso.
   */
  boolean importData(Object[] data);
}
